/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.io;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import net.doo.datamining.io.Arff;

public abstract class ArffAttribute<T> {
    public final String name;

    public ArffAttribute(String name) {
        this.name = name;
    }

    public abstract void writeValue(Writer var1, T var2) throws IOException;

    public abstract void writeHeader(Writer var1) throws IOException;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArffAttribute other = (ArffAttribute)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.name + "]";
    }

    public static class NominalArffAttribute
    extends StringArffAttribute {
        final ImmutableSet<String> values;

        public NominalArffAttribute(String name, Collection<String> values) {
            super(name);
            this.values = ImmutableSet.copyOf(values);
        }

        @Override
        public void writeValue(Writer out, String t) throws IOException {
            if (!this.values.contains(t) && t != null) {
                throw new IOException("Could not write value '" + t + "' for " + "nominal attribute '" + this.name + "', not an allowed " + "value. Allowed values: " + this.values);
            }
            super.writeValue(out, t);
        }

        @Override
        public void writeHeader(Writer out) throws IOException {
            out.write("@attribute");
            out.write(32);
            Arff.writeEscapedString(out, this.name);
            out.write(" {");
            Iterator iter = this.values.iterator();
            while (iter.hasNext()) {
                Arff.writeEscapedString(out, (String)iter.next());
                if (!iter.hasNext()) continue;
                out.write(44);
            }
            out.write("}\n");
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            return ((NominalArffAttribute)o).values.equals(this.values);
        }
    }

    public static class StringArffAttribute
    extends ArffAttribute<String> {
        public StringArffAttribute(String name) {
            super(name);
        }

        @Override
        public void writeValue(Writer out, String t) throws IOException {
            if (t == null) {
                out.write("?");
            } else {
                Arff.writeEscapedString(out, t);
            }
        }

        @Override
        public void writeHeader(Writer out) throws IOException {
            out.write("@attribute");
            out.write(32);
            Arff.writeEscapedString(out, this.name);
            out.write(32);
            out.write("string");
            out.write(10);
        }
    }

    public static class NumericArffAttribute
    extends ArffAttribute<Double> {
        public NumericArffAttribute(String name) {
            super(name);
        }

        @Override
        public void writeValue(Writer out, Double t) throws IOException {
            if (t == null) {
                out.write("?");
            } else {
                out.write(t.toString());
            }
        }

        @Override
        public void writeHeader(Writer out) throws IOException {
            out.write("@attribute");
            out.write(32);
            Arff.writeEscapedString(out, this.name);
            out.write(32);
            out.write("numeric");
            out.write(10);
        }
    }
}

