/*
 * Decompiled with CFR 0.152.
 */
package net.doo.datamining.util;

import java.io.OutputStreamWriter;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class LogUtils {
    public static void initConsoleLogging(String logLevel) {
        Level level = Level.toLevel(logLevel);
        ConsoleAppender console = new ConsoleAppender();
        console.setWriter(new OutputStreamWriter(System.out));
        console.setThreshold(level);
        console.setLayout(new Layout(){

            @Override
            public void activateOptions() {
            }

            @Override
            public boolean ignoresThrowable() {
                return false;
            }

            @Override
            public String format(LoggingEvent event) {
                StringBuilder b = new StringBuilder(512);
                b.append(event.getRenderedMessage()).append('\n');
                String[] throwableStrRep = event.getThrowableStrRep();
                if (throwableStrRep != null) {
                    for (String s : throwableStrRep) {
                        b.append(s).append('\n');
                    }
                }
                return b.toString();
            }
        });
        Logger.getRootLogger().removeAllAppenders();
        Logger.getRootLogger().addAppender(console);
        Logger.getRootLogger().setLevel(level);
    }
}

