package net.doo.snap.lib.analytics;

import android.app.Activity;

import com.google.analytics.tracking.android.EasyTracker;

import net.doo.snap.lib.BuildConfig;

/**
 * Wraps {@link com.google.analytics.tracking.android.EasyTracker} to not produce analytic reports while
 * in debug mode
 */
public class EasyTrackerWrapper {

    /**
     * @see com.google.analytics.tracking.android.Tracker#sendEvent(String, String, String, Long)
     */
    public static void sendEvent(String category, String action, String label, Long value) {
        if (BuildConfig.DEBUG) return;
        EasyTracker.getTracker().sendEvent(category, action, label, value);
    }

    /**
     * @see com.google.analytics.tracking.android.EasyTracker#activityStart(android.app.Activity)
     */
    public static void activityStart(Activity activity) {
        if (BuildConfig.DEBUG) return;
        EasyTracker.getInstance().activityStart(activity);
    }

    /**
     * @see com.google.analytics.tracking.android.EasyTracker#activityStop(android.app.Activity)
     */
    public static void activityStop(Activity activity) {
        if (BuildConfig.DEBUG) return;
        EasyTracker.getInstance().activityStop(activity);
    }


}
