package net.doo.snap.lib.snap.camera.barcode;

import com.google.inject.Inject;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;

/**
 * Manages barcode detection operations and detector initialization
 */
public class BarcodeDetector {

    private final MultiFormatReader multiFormatReader;
    private Result lastResult;

    @Inject
    public BarcodeDetector() {
        this.multiFormatReader = new MultiFormatReader();
    }

    /**
     * @return last detected barcode content
     */
    public Result getLastResult() {
        return lastResult;
    }

    /**
     * Decodes {@link com.google.zxing.BinaryBitmap} and detects barcodes
     * @param bitmap {@link com.google.zxing.BinaryBitmap} from camera host
     * @return detected barcode content
     */
    public Result decodeWithState(BinaryBitmap bitmap) {
        try {
            lastResult = multiFormatReader.decodeWithState(bitmap);
            return lastResult;
        } catch (ReaderException re) {
            // continue
        } finally {
            multiFormatReader.reset();
        }
        return null;
    }
}
