/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.edit;

import android.app.ActionBar;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.doo.snap.lib.analytics.ActivityAnalytics;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.edit.DrawMagnifierListener;
import net.doo.snap.lib.edit.EditPolygonImageView;
import net.doo.snap.lib.edit.MagnifierView;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PageStoreStrategy;
import net.doo.snap.lib.persistence.PictureProcessor;
import net.doo.snap.lib.persistence.Signature;
import net.doo.snap.lib.util.bitmap.BitmapLruCache;
import net.doo.snap.lib.util.bitmap.BitmapUtils;
import net.doo.snap.lib.util.bitmap.PageBitmapLoader;
import net.doo.snap.lib.util.log.DebugLog;
import roboguice.activity.RoboFragmentActivity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditPolygonActivity
extends RoboFragmentActivity
implements LoaderManager.LoaderCallbacks<Bitmap>,
DrawMagnifierListener {
    public static final String PAGE = "page";
    private static final String POLYGON = "polygon";
    private static final String LOADER_PATH = "LOADER_PATH";
    private final Executor executor = Executors.newSingleThreadExecutor();
    @Inject
    private PageStoreStrategy pageStoreStrategy;
    @Inject
    private ActivityAnalytics activityAnalytics;
    @Inject
    private BitmapLruCache bitmapLruCache;
    private Bitmap bitmap;
    private EditPolygonImageView image;
    private MagnifierView magnifierView;
    private Page page;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903052);
        this.page = (Page)this.getIntent().getParcelableExtra(PAGE);
        if (this.page == null) {
            this.finish();
            return;
        }
        ActionBar actionBar = this.getActionBar();
        actionBar.setDisplayShowHomeEnabled(false);
        actionBar.setDisplayShowTitleEnabled(false);
        actionBar.setDisplayShowCustomEnabled(true);
        actionBar.setDisplayHomeAsUpEnabled(false);
        actionBar.setCustomView(2130903050);
        this.image = (EditPolygonImageView)this.findViewById(2131165193);
        this.image.setRotation(this.page.getRotationType().getDegrees());
        this.magnifierView = (MagnifierView)this.findViewById(2131165226);
        this.setPolygon(savedInstanceState);
        try {
            Bundle args = this.buildLoaderArgs();
            this.getSupportLoaderManager().initLoader(0, args, (LoaderManager.LoaderCallbacks)this);
        }
        catch (IOException e) {
            DebugLog.logException(e);
        }
        View done = this.findViewById(2131165224);
        done.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EditPolygonActivity.this.page.setPolygon(EditPolygonActivity.this.image.getPolygon());
                new ImageProcessor().execute(new Page[]{EditPolygonActivity.this.page});
            }
        });
    }

    private Bundle buildLoaderArgs() throws IOException {
        Bundle args = new Bundle();
        args.putString(LOADER_PATH, this.page.getFilePath(this.pageStoreStrategy, Page.ImageType.PREVIEW));
        return args;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelableArrayList(POLYGON, (ArrayList)this.image.getPolygon());
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131623938, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        if (item.getItemId() == 2131165250) {
            try {
                File image = this.page.getFile(this.pageStoreStrategy, Page.ImageType.PREVIEW);
                new DetectPolygon().executeOnExecutor(this.executor, new String[]{image.getAbsolutePath()});
                return true;
            }
            catch (IOException e) {
                DebugLog.logException(e);
                return false;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void setPolygon(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            this.image.setPolygon(this.page.getPolygon());
            return;
        }
        ArrayList polygon = savedInstanceState.getParcelableArrayList(POLYGON);
        this.image.setPolygon(polygon);
    }

    public Loader<Bitmap> onCreateLoader(int i, Bundle args) {
        String path = args.getString(LOADER_PATH);
        return new PageBitmapLoader((Context)this, path, this.bitmapLruCache, this.bitmap);
    }

    public void onLoadFinished(Loader<Bitmap> loader, Bitmap result) {
        this.image.setImageBitmap(result);
        this.bitmap = result;
        this.image.setAlpha(0.0f);
        this.image.animate().alpha(1.0f).start();
        this.magnifierView.setupMagnifier(this.image);
    }

    public void onLoaderReset(Loader<Bitmap> loader) {
        this.bitmap = null;
        this.image.setImageDrawable(null);
    }

    @Override
    public void drawMagnifier(PointF zoomPoint) {
        this.magnifierView.drawMagnifier(zoomPoint);
    }

    @Override
    public void eraseMagnifier() {
        this.magnifierView.eraseMagnifier();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DetectPolygon
    extends AsyncTask<String, Void, List<PointF>> {
        DetectPolygon() {
        }

        protected List<PointF> doInBackground(String ... params) {
            List<PointF> polygon = Collections.emptyList();
            String fileName = params[0];
            try {
                ContourDetector detector = new ContourDetector();
                DetectionResult detectionResult = detector.detect(fileName);
                switch (detectionResult) {
                    case OK: 
                    case OK_BUT_BAD_ANGLES: 
                    case OK_BUT_TOO_SMALL: 
                    case OK_BUT_BAD_ASPECT_RATIO: {
                        polygon = detector.getPolygonF();
                    }
                }
            }
            catch (IOException e) {
                DebugLog.logException(e);
            }
            return polygon;
        }

        protected void onPostExecute(List<PointF> polygon) {
            if (!this.isCancelled() && !polygon.isEmpty() && EditPolygonActivity.this.image != null) {
                EditPolygonActivity.this.image.setPolygon(polygon);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImageProcessor
    extends AsyncTask<Page, Void, Void> {
        ImageProcessor() {
        }

        protected Void doInBackground(Page ... params) {
            Page page = params[0];
            if (!this.isCancelled() && EditPolygonActivity.this.pageStoreStrategy != null) {
                ContourDetector detector = new ContourDetector();
                try {
                    PictureProcessor.generateOptimizedPreview(EditPolygonActivity.this.pageStoreStrategy, page, detector);
                    this.ensureSignatureWithinBounds(page);
                }
                catch (IOException e) {
                    DebugLog.logException(e);
                }
            }
            return null;
        }

        private void ensureSignatureWithinBounds(Page page) throws IOException {
            Signature signature = page.getSignature();
            if (signature == null) {
                return;
            }
            RectF bounds = new RectF(BitmapUtils.getBitmapBounds(page.getFilePath(EditPolygonActivity.this.pageStoreStrategy, Page.ImageType.OPTIMIZED_PREVIEW)));
            Matrix matrix = new Matrix();
            matrix.setRotate((float)page.getRotationType().getDegrees(), bounds.centerX(), bounds.centerY());
            matrix.mapRect(bounds);
            bounds.offsetTo(0.0f, 0.0f);
            if (!this.signatureWithinBounds(signature, bounds)) {
                page.setSignature(null);
            }
        }

        private boolean signatureWithinBounds(Signature signature, RectF bounds) {
            RectF signatureBounds = this.getSignatureBounds(bounds, signature);
            return bounds.contains(signatureBounds);
        }

        private RectF getSignatureBounds(RectF pageBounds, Signature signature) {
            Rect imageBounds = BitmapUtils.getBitmapBounds(signature.getImagePath());
            float left = signature.getOrigin().x * pageBounds.width();
            float top = signature.getOrigin().y * pageBounds.height();
            return new RectF(left, top, left + signature.getScale() * (float)imageBounds.width(), top + signature.getScale() * (float)imageBounds.height());
        }

        protected void onPostExecute(Void aVoid) {
            if (!this.isCancelled()) {
                Intent result = new Intent();
                result.putExtra(EditPolygonActivity.PAGE, (Parcelable)EditPolygonActivity.this.page);
                EditPolygonActivity.this.setResult(-1, result);
                EditPolygonActivity.this.finish();
            }
        }
    }
}

