/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.util;

import android.annotation.TargetApi;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TransformableDrawable
extends Drawable {
    public static final String PROPERTY_ROTATION = "rotation";
    public static final String PROPERTY_SCALE = "scale";
    private Drawable wrappedDrawable;
    private float rotation = 0.0f;
    private float scale = 1.0f;

    public TransformableDrawable(Drawable wrappedDrawable) throws NullPointerException {
        if (wrappedDrawable == null) {
            throw new NullPointerException("Wrapped drawable can't be null");
        }
        this.wrappedDrawable = wrappedDrawable;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
        this.invalidateSelf();
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        int halfWidth = bounds.centerX();
        int halfHeight = bounds.centerY();
        canvas.save();
        canvas.scale(this.scale, this.scale, (float)halfWidth, (float)halfHeight);
        canvas.rotate(this.rotation, (float)halfWidth, (float)halfHeight);
        this.wrappedDrawable.draw(canvas);
        canvas.restore();
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.wrappedDrawable.setBounds(left, top, right, bottom);
    }

    public void setBounds(Rect bounds) {
        super.setBounds(bounds);
        this.wrappedDrawable.setBounds(bounds);
    }

    public void setChangingConfigurations(int configs) {
        this.wrappedDrawable.setChangingConfigurations(configs);
    }

    public int getChangingConfigurations() {
        return this.wrappedDrawable.getChangingConfigurations();
    }

    public void setDither(boolean dither) {
        this.wrappedDrawable.setDither(dither);
    }

    public void setFilterBitmap(boolean filter) {
        this.wrappedDrawable.setFilterBitmap(filter);
    }

    public void setAlpha(int alpha) {
        this.wrappedDrawable.setAlpha(alpha);
    }

    @TargetApi(value=19)
    public int getAlpha() {
        return this.wrappedDrawable.getAlpha();
    }

    public void setColorFilter(ColorFilter cf) {
        this.wrappedDrawable.setColorFilter(cf);
    }

    public void setColorFilter(int color2, PorterDuff.Mode mode) {
        this.wrappedDrawable.setColorFilter(color2, mode);
    }

    public void clearColorFilter() {
        this.wrappedDrawable.clearColorFilter();
    }

    public boolean isStateful() {
        return this.wrappedDrawable.isStateful();
    }

    public boolean setState(int[] stateSet) {
        return this.wrappedDrawable.setState(stateSet);
    }

    public int[] getState() {
        return this.wrappedDrawable.getState();
    }

    @TargetApi(value=11)
    public void jumpToCurrentState() {
        this.wrappedDrawable.jumpToCurrentState();
    }

    public Drawable getCurrent() {
        return this.wrappedDrawable.getCurrent();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        return this.wrappedDrawable.setVisible(visible, restart);
    }

    public int getOpacity() {
        return this.wrappedDrawable.getOpacity();
    }

    public Region getTransparentRegion() {
        return this.wrappedDrawable.getTransparentRegion();
    }

    public int getIntrinsicWidth() {
        return this.wrappedDrawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.wrappedDrawable.getIntrinsicHeight();
    }

    public int getMinimumWidth() {
        return 0;
    }

    public int getMinimumHeight() {
        return 0;
    }

    public boolean getPadding(Rect padding) {
        return this.wrappedDrawable.getPadding(padding);
    }

    public Drawable mutate() {
        return this;
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        this.wrappedDrawable.inflate(r, parser, attrs);
    }

    public Drawable.ConstantState getConstantState() {
        return this.wrappedDrawable.getConstantState();
    }
}

