/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageButton;
import java.util.ArrayList;

public class MultiStateImageButton
extends ImageButton {
    private GestureDetector gestureDetector;
    private ArrayList<State> states = new ArrayList();
    private SparseIntArray stateIdToPosition = new SparseIntArray();
    private int currentStateIndex = -1;
    private OnStateChangedListener onStateChangedListener;

    public MultiStateImageButton(Context context) {
        super(context);
        this.initView(context);
    }

    public MultiStateImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public MultiStateImageButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    private void initView(Context context) {
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener());
    }

    public void setOnClickListener(View.OnClickListener l) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.onStateChangedListener = onStateChangedListener;
    }

    public MultiStateImageButton addState(int id2, int drawableRes) {
        return this.addState(id2, this.getResources().getDrawable(drawableRes));
    }

    public MultiStateImageButton addState(int id2, Drawable drawable2) {
        State state = new State(id2, drawable2);
        this.stateIdToPosition.put(id2, this.states.size());
        this.states.add(state);
        if (this.currentStateIndex < 0) {
            this.currentStateIndex = 0;
            this.updateDrawable();
        }
        return this;
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        return this.gestureDetector.onTouchEvent(event);
    }

    public void moveToNextState() {
        if (this.states.isEmpty()) {
            return;
        }
        int newState = (this.currentStateIndex + 1) % this.states.size();
        if (this.pollListener(newState)) {
            this.currentStateIndex = newState;
            this.updateDrawable();
        }
    }

    public void setCurrentState(int id2) {
        this.currentStateIndex = this.getStatePosition(id2);
        this.updateDrawable();
    }

    private int getStatePosition(int id2) {
        int position = this.stateIdToPosition.get(id2, -1);
        if (position < 0) {
            throw new IllegalStateException("No state with id = " + id2);
        }
        return position;
    }

    private void updateDrawable() {
        this.setImageDrawable(this.states.get((int)this.currentStateIndex).drawable);
    }

    private boolean pollListener(int newState) {
        return this.onStateChangedListener == null || this.onStateChangedListener.onStateChange(this.states.get((int)newState).id);
    }

    private static class State {
        public final int id;
        public final Drawable drawable;

        private State(int id2, Drawable drawable2) {
            this.id = id2;
            this.drawable = drawable2;
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            MultiStateImageButton.this.moveToNextState();
            return true;
        }
    }

    public static interface OnStateChangedListener {
        public boolean onStateChange(int var1);
    }
}

