package net.doo.snap.lib.ui.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;

import net.doo.snap.lib.persistence.Signature;
import net.doo.snap.lib.util.bitmap.BitmapUtils;

/**
 * Draws {@link net.doo.snap.lib.persistence.Signature}s on top of the main content.
 */
public class SignedDrawable extends TransformableDrawable {
    private final Signature signature;
    private final Bitmap signatureBitmap;
    private final float additionalScaleFactor;

    private final Paint paint = new Paint(Paint.FILTER_BITMAP_FLAG);
    private Matrix matrix = new Matrix();
    private RectF rectF = new RectF();

    public SignedDrawable(Drawable wrappedDrawable, float additionalScaleFactor, Signature signature, Bitmap signatureBitmap) throws NullPointerException {
        super(wrappedDrawable);
        this.signature = signature;
        this.additionalScaleFactor = additionalScaleFactor;
        this.signatureBitmap = signatureBitmap;
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);

        drawSignature(canvas);
    }

    /**
     * Draws signature on the {@link android.graphics.Canvas}
     * <p/>
     * {@link net.doo.snap.lib.persistence.Signature} is translated according to value of {@link #getRotation()}
     * and {@link #getScale()}.
     * <p/>
     * It is assumed that {@link net.doo.snap.lib.persistence.Signature#getRect()} was calculated
     * for current {@link #getRotation()}.
     */
    public void drawSignature(Canvas canvas) {
        if (signature == null || !BitmapUtils.isBitmapValid(signatureBitmap)) {
            return;
        }

        final int width = getIntrinsicWidth();
        final int height = getIntrinsicHeight();

        rectF.set(
                0f, 0f,
                width, height
        );

        final float centerX = getBounds().centerX();
        final float centerY = getBounds().centerY();

        matrix.reset();
        matrix.setRotate(getRotation(), centerX, centerY);
        matrix.preScale(getScale(), getScale(), centerX, centerY);
        matrix.mapRect(rectF);

        canvas.save();
//        canvas.translate(
//                rectF.width() * signature.getOrigin().x + rectF.left,
//                rectF.height() * signature.getOrigin().y + rectF.top
//        );
        canvas.drawBitmap(signatureBitmap, 0, 0, paint);
        canvas.restore();
    }

}
