package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import com.google.zxing.Result;
import com.google.zxing.client.result.*;

/**
 * Manufactures Android-specific handlers based on the barcode content's type.
 */
public final class ResultHandlerFactory {
    private ResultHandlerFactory() {
    }

    /**
     * Creates instance of {@link net.doo.snap.lib.snap.camera.barcode.result.ResultHandler} for specific {@link com.google.zxing.Result}
     * @param activity
     * @param rawResult raw barcode content
     * @return {@link net.doo.snap.lib.snap.camera.barcode.result.ResultHandler} instance
     */
    public static ResultHandler makeResultHandler(Activity activity, Result rawResult) {
        ParsedResult result = parseResult(rawResult);
        switch (result.getType()) {
            case ADDRESSBOOK:
                return new AddressBookResultHandler(activity, (AddressBookParsedResult) result);
            case EMAIL_ADDRESS:
                return new EmailAddressResultHandler(activity, (EmailAddressParsedResult) result);
            case PRODUCT:
                return new ProductResultHandler(activity, result);
            case URI:
                return new URIResultHandler(activity, (URIParsedResult) result);
            case WIFI:
                return new WifiResultHandler(activity, (WifiParsedResult) result);
            case GEO:
                return new GeoResultHandler(activity, (GeoParsedResult) result);
            case TEL:
                return new TelResultHandler(activity, (TelParsedResult) result);
            case SMS:
                return new SMSResultHandler(activity, (SMSParsedResult) result);
            case CALENDAR:
                return new CalendarResultHandler(activity, (CalendarParsedResult) result);
            case ISBN:
                return new ISBNResultHandler(activity, (ISBNParsedResult) result);
            default:
                return new TextResultHandler(activity, result);
        }
    }

    private static ParsedResult parseResult(Result rawResult) {
        return ResultParser.parseResult(rawResult);
    }
}
