/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util.billing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.doo.snap.lib.util.billing.Purchase;
import net.doo.snap.lib.util.billing.SkuDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Inventory {
    private final Map<String, SkuDetails> skuMap = new HashMap<String, SkuDetails>();
    private final Map<String, Purchase> purchaseMap = new HashMap<String, Purchase>();

    Inventory() {
    }

    public SkuDetails getSkuDetails(String sku) {
        return this.skuMap.get(sku);
    }

    public Purchase getPurchase(String sku) {
        return this.purchaseMap.get(sku);
    }

    public boolean hasPurchase(String sku) {
        return this.purchaseMap.containsKey(sku);
    }

    public boolean hasDetails(String sku) {
        return this.skuMap.containsKey(sku);
    }

    public void erasePurchase(String sku) {
        this.purchaseMap.remove(sku);
    }

    public List<String> getAllOwnedSkus() {
        return new ArrayList<String>(this.purchaseMap.keySet());
    }

    public List<String> getAllOwnedSkus(String itemType) {
        ArrayList<String> result = new ArrayList<String>();
        for (Purchase purchase : this.purchaseMap.values()) {
            if (!purchase.getItemType().equals(itemType)) continue;
            result.add(purchase.getSku());
        }
        return result;
    }

    public List<Purchase> getAllPurchases() {
        return new ArrayList<Purchase>(this.purchaseMap.values());
    }

    public void addSkuDetails(SkuDetails skuDetails) {
        this.skuMap.put(skuDetails.getSku(), skuDetails);
    }

    public void addPurchase(Purchase purchase) {
        this.purchaseMap.put(purchase.getSku(), purchase);
    }
}

