/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.widget.text.processor;

import android.text.SpannableStringBuilder;
import java.util.ArrayList;

public class TextProcessor {
    private ArrayList<ProcessStrategy> strategies = new ArrayList();
    private ProcessStrategy currentStrategy;

    public TextProcessor addStrategy(ProcessStrategy strategy) throws NullPointerException {
        if (strategy == null) {
            throw new NullPointerException();
        }
        this.strategies.add(strategy);
        return this;
    }

    public CharSequence processText(String input) {
        if (this.strategies.isEmpty()) {
            return input;
        }
        this.resetStrategies();
        SpannableStringBuilder output = new SpannableStringBuilder();
        int strategiesCount = this.strategies.size();
        int inputLength = input.length();
        for (int position = 0; position < inputLength; ++position) {
            char currentChar = input.charAt(position);
            ProcessStrategy lastStrategy = null;
            if (this.currentStrategy != null) {
                if (this.currentStrategy.processChar(currentChar, output)) continue;
                lastStrategy = this.currentStrategy;
                this.currentStrategy = null;
            }
            boolean consumed = false;
            for (int i = 0; i < strategiesCount; ++i) {
                ProcessStrategy strategy = this.strategies.get(i);
                if (lastStrategy == strategy || !(consumed = strategy.processChar(currentChar, output))) continue;
                this.currentStrategy = strategy;
                break;
            }
            if (consumed) continue;
            output.append(currentChar);
        }
        return output;
    }

    private void resetStrategies() {
        for (ProcessStrategy strategy : this.strategies) {
            strategy.reset();
        }
    }

    public static interface ProcessStrategy {
        public boolean processChar(char var1, SpannableStringBuilder var2);

        public void reset();
    }
}

