/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.widget.signature;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import net.doo.snap.lib.R;
import net.doo.snap.lib.util.bitmap.BitmapUtils;

public class SignatureView
extends View {
    private Paint paint = new Paint();
    private Path path = new Path();
    private float lastTouchX;
    private float lastTouchY;
    private Bitmap bitmap;
    private Canvas bitmapCanvas;
    private boolean hasContent = false;

    public SignatureView(Context context) {
        super(context);
        this.initPaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignatureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initPaint();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SignatureView);
        try {
            this.paint.setStrokeWidth(a.getDimension(0, 0.0f));
            this.paint.setColor(a.getColor(1, -16777216));
        }
        finally {
            a.recycle();
        }
    }

    private void initPaint() {
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeJoin(Paint.Join.ROUND);
    }

    public void clear() {
        this.path.reset();
        if (this.bitmap != null) {
            this.bitmapCanvas.drawColor(-16777216, PorterDuff.Mode.CLEAR);
        }
        this.hasContent = false;
        this.invalidate();
    }

    public void setSignature(Bitmap input) {
        if (!BitmapUtils.isBitmapValid(input)) {
            this.clear();
            return;
        }
        this.bitmap = input.copy(Bitmap.Config.ARGB_8888, true);
        this.bitmapCanvas = new Canvas(this.bitmap);
        this.hasContent = true;
        this.invalidate();
    }

    public Bitmap getSignature() {
        if (!this.hasContent || !BitmapUtils.isBitmapValid(this.bitmap)) {
            return null;
        }
        return this.bitmap;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.bitmapCanvas = new Canvas(this.bitmap);
        this.hasContent = false;
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
    }

    public boolean onTouchEvent(MotionEvent event) {
        float eventX = event.getX();
        float eventY = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.path.moveTo(eventX, eventY);
                this.lastTouchX = eventX;
                this.lastTouchY = eventY;
                return true;
            }
            case 1: 
            case 2: {
                float pointX = (eventX + this.lastTouchX) / 2.0f;
                float pointY = (eventY + this.lastTouchY) / 2.0f;
                this.path.quadTo(this.lastTouchX, this.lastTouchY, pointX, pointY);
                if (this.bitmap != null) {
                    this.bitmapCanvas.drawPath(this.path, this.paint);
                }
                this.path.reset();
                this.path.moveTo(pointX, pointY);
                this.lastTouchX = eventX;
                this.lastTouchY = eventY;
                this.hasContent = true;
                this.invalidate();
                return true;
            }
        }
        return false;
    }
}

