/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.widget.text.processor;

import android.graphics.Typeface;
import android.text.SpannableStringBuilder;
import net.doo.snap.lib.ui.widget.text.CustomTypefaceSpan;
import net.doo.snap.lib.ui.widget.text.processor.TextProcessor;

public class StressedProcessStrategy
implements TextProcessor.ProcessStrategy {
    private static final char STRESS_SIGN = '*';
    private final Typeface stressed;
    Integer spanStart = null;

    public StressedProcessStrategy(Typeface stressed) {
        this.stressed = stressed;
    }

    public boolean processChar(char currentChar, SpannableStringBuilder output) {
        boolean consumed;
        if (currentChar == '*') {
            if (this.spanStart == null) {
                this.spanStart = output.length();
            } else {
                output.setSpan((Object)new CustomTypefaceSpan(this.stressed), this.spanStart.intValue(), output.length(), 33);
                this.spanStart = null;
            }
            return true;
        }
        boolean bl = consumed = this.spanStart != null;
        if (consumed) {
            output.append(currentChar);
        }
        return consumed;
    }

    public void reset() {
        this.spanStart = null;
    }
}

