package net.doo.snap.lib.snap.camera;

import com.google.inject.Inject;
import com.google.inject.Singleton;

/**
 * Stores camera preview configuration
 */
@Singleton
public class CameraPreviewConfiguration {

    @Inject
    public CameraPreviewConfiguration() {
    }

    /**
     * Represents flash toggle on camera preview
     * false bu default
     */
    private boolean isFlashEnabled = false;
    /**
     * Represents auto snapping toggle on camera preview
     * true bu default
     */
    private boolean isAutoSnapEnabled = true;

    /**
     * @return whether flash toggle is checked and torch mode enabled or not
     */
    public boolean isFlashEnabled() {
        return isFlashEnabled;
    }

    /**
     * Saves flash toggle checked state
     * @param isFlashEnabled
     */
    public void setFlashEnabled(boolean isFlashEnabled) {
        this.isFlashEnabled = isFlashEnabled;
    }

    /**
     * @return whether auto snap toggle is checked and auto snapping enabled or not
     */
    public boolean isAutoSnapEnabled() {
        return isAutoSnapEnabled;
    }

    /**
     * Saves auto snap toggle checked state
     * @param isAutoSnapEnabled
     */
    public void setAutoSnapEnabled(boolean isAutoSnapEnabled) {
        this.isAutoSnapEnabled = isAutoSnapEnabled;
    }
}
