/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.widget.text;

import android.content.Context;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import net.doo.snap.lib.ui.widget.text.CustomTypefaceTextView;

public class AutoscaleTextView
extends CustomTypefaceTextView {
    private static final float TEXT_SIZE_DELTA = 1.0f;

    public AutoscaleTextView(Context context) {
        super(context);
    }

    public AutoscaleTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AutoscaleTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.fitText(w - this.getPaddingLeft() - this.getPaddingRight());
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        this.fitText(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight());
    }

    private void fitText(int width) {
        float textSize;
        if (width <= 0) {
            return;
        }
        CharSequence text = this.getText();
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        TextPaint paint = this.getPaint();
        float diff = (float)width - paint.measureText(text, 0, text.length());
        if (diff > 0.0f) {
            return;
        }
        float rightBound = textSize = paint.getTextSize();
        float leftBound = 0.0f;
        do {
            textSize = (rightBound - leftBound) / 2.0f + leftBound;
            paint.setTextSize(textSize);
            diff = (float)width - paint.measureText(text, 0, text.length());
            if (diff < 0.0f) {
                rightBound = textSize;
                continue;
            }
            leftBound = textSize;
        } while (Math.abs(diff) > 1.0f && Math.abs(rightBound - leftBound) > 1.0f);
        this.setTextSize(0, textSize);
    }
}

