/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.SMSParsedResult;
import net.doo.snap.lib.snap.camera.barcode.result.ResultHandler;

public final class SMSResultHandler
extends ResultHandler {
    private static final int[] buttons = new int[]{2131165271, 2131165266};
    private static final int SEND_SMS = 0;
    private static final int SEND_MMS = 1;

    public SMSResultHandler(Activity activity, SMSParsedResult result) {
        super(activity, (ParsedResult)result);
    }

    public SMSParsedResult getResult() {
        return (SMSParsedResult)super.getResult();
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        SMSParsedResult smsResult = this.getResult();
        String number = smsResult.getNumbers()[0];
        switch (index) {
            case 0: {
                this.sendSMS(number, smsResult.getBody());
                break;
            }
            case 1: {
                this.sendMMS(number, smsResult.getSubject(), smsResult.getBody());
            }
        }
    }

    @Override
    public CharSequence getDisplayContents() {
        SMSParsedResult smsResult = this.getResult();
        String[] rawNumbers = smsResult.getNumbers();
        String[] formattedNumbers = new String[rawNumbers.length];
        for (int i = 0; i < rawNumbers.length; ++i) {
            formattedNumbers[i] = PhoneNumberUtils.formatNumber((String)rawNumbers[i]);
        }
        StringBuilder contents = new StringBuilder(50);
        ParsedResult.maybeAppend((String[])formattedNumbers, (StringBuilder)contents);
        ParsedResult.maybeAppend((String)smsResult.getSubject(), (StringBuilder)contents);
        ParsedResult.maybeAppend((String)smsResult.getBody(), (StringBuilder)contents);
        return contents.toString();
    }

    @Override
    public String getDisplayTitle() {
        return this.getActivity().getString(2131165276);
    }

    @Override
    public String getDisplaySubtitle() {
        return TextUtils.join((CharSequence)" ", (Object[])this.getResult().getNumbers());
    }

    @Override
    public String getDisplayText() {
        return this.getResult().getBody();
    }

    @Override
    public int getDisplayIconRes() {
        return 2130837584;
    }
}

