/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.edit.util;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.snap.PreviewFragmentPagerAdapter;
import net.doo.snap.lib.ui.util.ViewUtils;
import net.doo.snap.lib.ui.widget.ViewPager;

public class PageEditorHelper {
    private static final Interpolator PAGE_SLIDE_IN_INTERPOLATOR = new DecelerateInterpolator();
    private static final Interpolator PAGE_SLIDE_OUT_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private ViewPager pager;
    private PreviewFragmentPagerAdapter adapter;

    public PageEditorHelper(ViewPager pager, PreviewFragmentPagerAdapter adapter) {
        this.pager = pager;
        this.adapter = adapter;
    }

    public void deleteCurrentPage(Animator.AnimatorListener listener) {
        if (this.pager.getCurrentItem() == 0) {
            this.slideNextPageIn(listener);
        } else {
            this.slidePreviousPageIn(listener);
        }
    }

    private void slideNextPageIn(Animator.AnimatorListener listener) {
        int nextPosition = this.pager.getCurrentItem() + 1;
        if (!this.isValidPagePosition(nextPosition)) {
            return;
        }
        View nextView = this.adapter.getFragment(this.pager, nextPosition).getView();
        this.getPageSlideInAndDeleteAnimator(this.pager.getCurrentItem(), nextView, listener).translationX((float)(-(nextView.getWidth() + this.pager.getPageMargin()))).start();
    }

    private void slidePreviousPageIn(Animator.AnimatorListener listener) {
        int previousPosition = this.pager.getCurrentItem() - 1;
        if (!this.isValidPagePosition(previousPosition)) {
            return;
        }
        View previousView = this.adapter.getFragment(this.pager, previousPosition).getView();
        this.getPageSlideInAndDeleteAnimator(this.pager.getCurrentItem(), previousView, listener).translationX((float)(previousView.getWidth() + this.pager.getPageMargin())).start();
    }

    private ViewPropertyAnimator getPageSlideInAndDeleteAnimator(final int positionToDelete, final View viewToSlide, final Animator.AnimatorListener listener) {
        return viewToSlide.animate().setInterpolator((TimeInterpolator)PAGE_SLIDE_IN_INTERPOLATOR).setListener((Animator.AnimatorListener)new ViewUtils.DefaultAnimationListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                if (listener != null) {
                    listener.onAnimationStart(animation);
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {
                if (listener != null) {
                    listener.onAnimationCancel(animation);
                }
            }

            @Override
            public void onAnimationRepeat(Animator animation) {
                if (listener != null) {
                    listener.onAnimationRepeat(animation);
                }
            }

            @Override
            public void onAnimationFinished(Animator animation) {
                if (!PageEditorHelper.this.pager.isAttachedToWindow() || !PageEditorHelper.this.isValidPagePosition(positionToDelete)) {
                    viewToSlide.setTranslationX(0.0f);
                    return;
                }
                int currentPosition = PageEditorHelper.this.pager.getCurrentItem();
                if (currentPosition == positionToDelete) {
                    PageEditorHelper.this.pager.setCurrentItem(currentPosition - 1, false);
                }
                PageEditorHelper.this.adapter.deletePage(positionToDelete);
                viewToSlide.setTranslationX(0.0f);
                if (listener != null) {
                    listener.onAnimationEnd(animation);
                }
            }
        });
    }

    public void addPageToPosition(Page page, int position, Animator.AnimatorListener listener) {
        page.getParameters().putBoolean("PLAY_DROP_IN_ANIMATION", true);
        page.getParameters().putFloat("DROP_X", (float)(this.pager.getWidth() / 2));
        page.getParameters().putFloat("DROP_Y", (float)this.pager.getHeight());
        this.adapter.addPage(position, page);
        this.pager.setCurrentItem(position);
        if (this.adapter.getPagesCount() > 1) {
            if (position == 0) {
                this.slideNextPageOut(listener);
            } else {
                this.slidePreviousPageOut(listener);
            }
        }
    }

    public void addPageToTheLeft(Page page, Animator.AnimatorListener listener) {
        int currentItem = this.pager.getCurrentItem();
        this.adapter.addPage(currentItem, page);
        this.pager.setCurrentItem(currentItem, false);
        this.slideNextPageOut(listener);
    }

    public void addPageToTheRight(Page page, Animator.AnimatorListener listener) {
        int currentItem = this.pager.getCurrentItem();
        this.adapter.addPage(currentItem + 1, page);
        this.pager.setCurrentItem(currentItem + 1, false);
        this.slidePreviousPageOut(listener);
    }

    private void slideNextPageOut(Animator.AnimatorListener listener) {
        View view = this.adapter.getFragment(this.pager, this.pager.getCurrentItem() + 1).getView();
        view.setTranslationX((float)(-(view.getWidth() + this.pager.getPageMargin())));
        this.getPageSlideOutAnimator(view).setListener(listener).start();
    }

    private void slidePreviousPageOut(Animator.AnimatorListener listener) {
        View view = this.adapter.getFragment(this.pager, this.pager.getCurrentItem() - 1).getView();
        view.setTranslationX((float)(view.getWidth() + this.pager.getPageMargin()));
        this.getPageSlideOutAnimator(view).setListener(listener).start();
    }

    private ViewPropertyAnimator getPageSlideOutAnimator(View viewToSlide) {
        return viewToSlide.animate().translationX(0.0f).setInterpolator((TimeInterpolator)PAGE_SLIDE_OUT_INTERPOLATOR);
    }

    private boolean isValidPagePosition(int position) {
        return position >= 0 && position < this.adapter.getCount() - 1 && this.adapter.getFragment(this.pager, position) != null && this.adapter.getFragment(this.pager, position).getView() != null;
    }
}

