/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.edit;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import net.doo.snap.lib.edit.DrawMagnifierListener;
import net.doo.snap.lib.snap.util.PolygonHelper;
import net.doo.snap.lib.util.log.DebugLog;

public class EditPolygonImageView
extends ImageView {
    private static final int CORNERS_COUNT = 4;
    private Paint paint;
    private Paint handlePaint;
    private PolygonHelper polygonHelper;
    private float rotationScale = 1.0f;
    private List<PointF> polygon;
    private List<PointF> corners;
    private List<Edge> edges;
    private float offsetX;
    private float offsetY;
    private Bitmap cornerBitmap;
    private Bitmap edgeBitmap;
    private int handleSize;
    private PointF selectedCorner;
    private Edge selectedEdge;
    private PointF tmpPointA = new PointF();
    private PointF tmpPointB = new PointF();
    private float medianX;
    private float medianY;
    private PriorityQueue<PointF> pointsQueue = new PriorityQueue<PointF>(4, new Comparator<PointF>(){

        @Override
        public int compare(PointF lhs, PointF rhs) {
            double first = Math.atan2(lhs.y - EditPolygonImageView.this.medianY, lhs.x - EditPolygonImageView.this.medianX);
            double second = Math.atan2(rhs.y - EditPolygonImageView.this.medianY, rhs.x - EditPolygonImageView.this.medianX);
            return Double.compare(first, second);
        }
    });
    private DrawMagnifierListener magnifierListener;
    private float[] imageMatrix = new float[9];
    private RectF touchRect = new RectF();
    private float polygonStrokeWidth = this.getResources().getDimension(2131427333);

    public EditPolygonImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int i;
        this.polygon = Collections.emptyList();
        this.paint = new Paint();
        this.paint.setColor(this.getResources().getColor(2131230745));
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.polygonStrokeWidth);
        this.paint.setAntiAlias(true);
        this.handlePaint = new Paint();
        this.handlePaint.setAntiAlias(true);
        this.handlePaint.setFilterBitmap(true);
        this.polygonHelper = new PolygonHelper();
        this.corners = new ArrayList<PointF>();
        for (i = 0; i < 4; ++i) {
            this.corners.add(new PointF());
        }
        this.edges = new ArrayList<Edge>();
        for (i = 0; i < this.corners.size(); ++i) {
            Edge edge = new Edge();
            edge.pointA = this.corners.get(i);
            edge.pointB = this.corners.get((i + 1) % 4);
            edge.pointFarA = this.corners.get((i + 3) % 4);
            edge.pointFarB = this.corners.get((i + 2) % 4);
            this.edges.add(edge);
        }
        try {
            this.magnifierListener = (DrawMagnifierListener)context;
        }
        catch (ClassCastException e) {
            DebugLog.logException(e);
        }
        this.handleSize = this.getResources().getDimensionPixelSize(2131427341);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.cornerBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837565, (BitmapFactory.Options)options);
        this.edgeBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837569, (BitmapFactory.Options)options);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cornerBitmap.recycle();
        this.edgeBitmap.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getDrawable() != null) {
            this.offsetX = 0.0f;
            this.offsetY = 0.0f;
            this.getImageMatrix().getValues(this.imageMatrix);
            float scaleX = this.imageMatrix[0];
            float scaleY = this.imageMatrix[4];
            Drawable d = this.getDrawable();
            int origW = d.getIntrinsicWidth();
            int origH = d.getIntrinsicHeight();
            int actW = Math.round((float)origW * scaleX);
            int actH = Math.round((float)origH * scaleY);
            if (actW < this.getMeasuredWidth()) {
                this.offsetX = this.getMeasuredWidth() - actW >> 1;
            }
            if (actH < this.getMeasuredHeight()) {
                this.offsetY = this.getMeasuredHeight() - actH >> 1;
            }
            this.polygonHelper.setImageSize(actW, actH);
            if (!this.polygon.isEmpty()) {
                this.polygonHelper.getDrawingPolygon(this.polygon, this.corners);
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.getDrawable() != null) {
            this.rotateAndScale();
        }
    }

    public void setPolygon(List<PointF> polygon) {
        if (!polygon.isEmpty()) {
            this.polygon = polygon;
            this.polygonHelper.getDrawingPolygon(polygon, this.corners);
            this.invalidate();
        }
    }

    public List<PointF> getPolygon() {
        this.polygonHelper.getPolygonFromDrawingPolygon(this.corners, this.polygon);
        return this.polygon;
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (!this.polygon.isEmpty()) {
            canvas.save();
            canvas.translate(this.offsetX, this.offsetY);
            for (int i = 0; i < this.corners.size(); ++i) {
                PointF startPoint = this.corners.get(i);
                PointF endPoint = this.corners.get((i + 1) % 4);
                canvas.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y, this.paint);
            }
            if (this.selectedCorner != null) {
                this.drawHandle(canvas, this.selectedCorner, this.cornerBitmap, 0.0f);
                canvas.save();
                canvas.translate(-this.offsetX, -this.offsetY);
                if (this.magnifierListener != null) {
                    this.magnifierListener.drawMagnifier(this.selectedCorner);
                }
                canvas.restore();
            } else if (this.selectedEdge != null) {
                this.drawHandle(canvas, this.selectedEdge.getHandle(), this.edgeBitmap, this.selectedEdge.getAngleInDegrees());
            } else {
                for (Edge edge : this.edges) {
                    this.drawHandle(canvas, edge.getHandle(), this.edgeBitmap, edge.getAngleInDegrees());
                }
                for (PointF point : this.corners) {
                    this.drawHandle(canvas, point, this.cornerBitmap, 0.0f);
                }
            }
            canvas.restore();
        }
    }

    private void drawHandle(Canvas canvas, PointF point, Bitmap handle, float degrees) {
        canvas.save();
        if (degrees != 0.0f) {
            canvas.rotate(degrees, point.x, point.y);
        }
        float counterScale = 1.0f / this.rotationScale;
        canvas.scale(counterScale, counterScale, point.x, point.y);
        canvas.drawBitmap(handle, point.x - (float)(handle.getWidth() >> 1), point.y - (float)(handle.getHeight() >> 1), this.handlePaint);
        canvas.restore();
    }

    private void keepInsideView(PointF point) {
        float x = Math.max(0.0f, Math.min(point.x, (float)this.getWidth() - 2.0f * this.offsetX));
        float y = Math.max(0.0f, Math.min(point.y, (float)this.getHeight() - 2.0f * this.offsetY));
        point.set(x, y);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                int halfHandleSize = this.handleSize >> 1;
                this.touchRect.set(event.getX() - this.offsetX - (float)halfHandleSize, event.getY() - this.offsetY - (float)halfHandleSize, event.getX() - this.offsetX + (float)halfHandleSize, event.getY() - this.offsetY + (float)halfHandleSize);
                for (PointF point : this.corners) {
                    if (!this.touchRect.contains(point.x, point.y)) continue;
                    this.selectedCorner = point;
                    this.invalidate();
                    return true;
                }
                for (Edge edge : this.edges) {
                    PointF edgeHandle = edge.getHandle();
                    if (!this.touchRect.contains(edgeHandle.x, edgeHandle.y)) continue;
                    this.selectedEdge = edge;
                    edge.prevX = event.getX();
                    edge.prevY = event.getY();
                    edge.lineA.calculateLine(edge.pointA, edge.pointFarA);
                    edge.lineB.calculateLine(edge.pointB, edge.pointFarB);
                    this.invalidate();
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.selectedCorner != null) {
                    this.selectedCorner.set(event.getX() - this.offsetX, event.getY() - this.offsetY);
                    this.keepInsideView(this.selectedCorner);
                    this.ensureNoPolygonIntersection();
                    this.invalidate();
                } else if (this.selectedEdge != null) {
                    float dx = event.getX() - this.selectedEdge.prevX;
                    float dy = event.getY() - this.selectedEdge.prevY;
                    this.tmpPointA.set(this.selectedEdge.pointA);
                    this.tmpPointB.set(this.selectedEdge.pointB);
                    this.selectedEdge.pointA.offset(dx, dy);
                    this.selectedEdge.pointB.offset(dx, dy);
                    this.selectedEdge.edgeLine.calculateLine(this.selectedEdge.pointA, this.selectedEdge.pointB);
                    PointF intersectionA = this.selectedEdge.edgeLine.getIntersectionPoint(this.selectedEdge.lineA);
                    if (Float.isNaN(intersectionA.x) || Float.isNaN(intersectionA.y)) {
                        this.restoreSelectedEdge();
                        return false;
                    }
                    this.selectedEdge.pointA.set(intersectionA);
                    PointF intersectionB = this.selectedEdge.edgeLine.getIntersectionPoint(this.selectedEdge.lineB);
                    if (Float.isNaN(intersectionB.x) || Float.isNaN(intersectionB.y)) {
                        this.restoreSelectedEdge();
                        return false;
                    }
                    this.selectedEdge.pointB.set(intersectionB);
                    this.keepInsideView(this.selectedEdge.pointA);
                    this.keepInsideView(this.selectedEdge.pointB);
                    this.selectedEdge.prevX = event.getX();
                    this.selectedEdge.prevY = event.getY();
                    this.invalidate();
                }
                return true;
            }
            case 1: 
            case 3: {
                this.selectedCorner = null;
                this.selectedEdge = null;
                if (this.magnifierListener != null) {
                    this.magnifierListener.eraseMagnifier();
                }
                this.invalidate();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private void restoreSelectedEdge() {
        this.selectedEdge.pointA.set(this.tmpPointA);
        this.selectedEdge.pointB.set(this.tmpPointB);
        this.selectedEdge.edgeLine.calculateLine(this.selectedEdge.pointA, this.selectedEdge.pointB);
    }

    private void ensureNoPolygonIntersection() {
        this.calculateMedian();
        if (this.ensureCornersOrder()) {
            this.ensureEdgesOrder();
        }
    }

    private boolean ensureCornersOrder() {
        boolean changed = false;
        this.pointsQueue.addAll(this.corners);
        for (int i = 0; i < 4; ++i) {
            PointF pointF = (PointF)this.pointsQueue.remove();
            if (!pointF.equals((Object)this.corners.get(i))) {
                changed = true;
            }
            this.corners.set(i, pointF);
        }
        return changed;
    }

    private void calculateMedian() {
        float sx = 0.0f;
        float sy = 0.0f;
        for (int i = 0; i < 4; ++i) {
            PointF pointF = this.corners.get(i);
            sx += pointF.x;
            sy += pointF.y;
        }
        this.medianX = sx / 4.0f;
        this.medianY = sy / 4.0f;
    }

    private void ensureEdgesOrder() {
        for (int i = 0; i < 4; ++i) {
            Edge edge = this.edges.get(i);
            edge.pointA = this.corners.get(i);
            edge.pointB = this.corners.get((i + 1) % 4);
            edge.pointFarA = this.corners.get((i + 3) % 4);
            edge.pointFarB = this.corners.get((i + 2) % 4);
        }
    }

    private void rotateAndScale() {
        this.rotationScale = this.calculateRotationScale();
        this.setScaleX(this.rotationScale);
        this.setScaleY(this.rotationScale);
        float counterScale = 1.0f / this.rotationScale;
        this.paint.setStrokeWidth(counterScale * this.polygonStrokeWidth);
    }

    private float calculateRotationScale() {
        if (this.getRotation() != 90.0f && this.getRotation() != 270.0f) {
            return 1.0f;
        }
        float availableWidth = this.getWidth();
        float availableHeight = this.getHeight();
        return Math.min(availableWidth / (availableHeight - this.offsetY * 2.0f), availableHeight / (availableWidth - this.offsetX * 2.0f));
    }

    private class Line {
        private double a;
        private double b;
        private double c;
        private PointF intersectionPoint = new PointF();

        private Line() {
        }

        PointF getIntersectionPoint(Line line) {
            this.intersectionPoint.x = (float)((this.c * line.b - this.b * line.c) / (this.b * line.a - this.a * line.b));
            this.intersectionPoint.y = (float)((this.a * line.c - this.c * line.a) / (this.b * line.a - this.a * line.b));
            return this.intersectionPoint;
        }

        void calculateLine(PointF start, PointF end) {
            this.a = start.y - end.y;
            this.b = end.x - start.x;
            this.c = (start.x - end.x) * start.y + (end.y - start.y) * start.x;
        }
    }

    private class Edge {
        private PointF pointA;
        private PointF pointB;
        private PointF pointFarA;
        private PointF pointFarB;
        private Line edgeLine;
        private Line lineA;
        private Line lineB;
        private PointF handle;
        private float prevX;
        private float prevY;

        private Edge() {
            this.edgeLine = new Line();
            this.lineA = new Line();
            this.lineB = new Line();
            this.handle = new PointF();
        }

        float getAngleInDegrees() {
            float dy = this.pointB.y - this.pointA.y;
            float dx = this.pointB.x - this.pointA.x;
            double angle = Math.atan2(dy, dx);
            angle = Math.toDegrees(angle);
            return (float)(angle += 90.0);
        }

        PointF getHandle() {
            this.handle.x = (this.pointA.x + this.pointB.x) / 2.0f;
            this.handle.y = (this.pointA.y + this.pointB.y) / 2.0f;
            return this.handle;
        }
    }
}

