/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.edit;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import net.doo.snap.lib.edit.DrawMagnifierListener;

public class MagnifierView
extends View
implements DrawMagnifierListener {
    private Magnifier magnifier = new Magnifier();
    private PointF zoomPoint;
    private Bitmap magnifierBitmap;

    public MagnifierView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public void drawMagnifier(PointF zoomPoint) {
        this.zoomPoint = zoomPoint;
        this.invalidate();
    }

    @Override
    public void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    public void setupMagnifier(ImageView view) {
        this.magnifier.setup(view);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.zoomPoint != null) {
            this.magnifier.draw(canvas, this.zoomPoint);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.magnifierBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837568, (BitmapFactory.Options)options);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.magnifierBitmap.recycle();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.magnifier.setViewDimensions(this.getWidth(), this.getHeight());
    }

    private class Magnifier {
        private final float ZOOM = 2.0f;
        private float bitmapScale;
        private int viewWidth;
        private int viewHeight;
        private BitmapShader shader;
        private Paint shaderPaint;
        private Matrix matrix;
        private Paint magnifierPaint = new Paint();
        private Paint magnifierCrossPaint;
        private float radius;
        private float crossSize;
        private float margin;
        private float offsetX;
        private float offsetY;
        private float rotation;
        private BitmapDrawable drawable;

        Magnifier() {
            this.magnifierPaint.setColor(MagnifierView.this.getResources().getColor(2131230751));
            this.magnifierPaint.setStyle(Paint.Style.STROKE);
            this.magnifierPaint.setStrokeWidth(MagnifierView.this.getResources().getDimension(2131427338));
            this.magnifierPaint.setAntiAlias(true);
            this.magnifierCrossPaint = new Paint();
            this.magnifierCrossPaint.setColor(MagnifierView.this.getResources().getColor(2131230751));
            this.magnifierCrossPaint.setStyle(Paint.Style.STROKE);
            this.magnifierCrossPaint.setStrokeWidth(MagnifierView.this.getResources().getDimension(2131427337));
            this.magnifierCrossPaint.setAntiAlias(true);
            this.shaderPaint = new Paint();
            this.matrix = new Matrix();
            this.radius = MagnifierView.this.getResources().getDimension(2131427339);
            this.crossSize = MagnifierView.this.getResources().getDimension(2131427336);
            this.margin = MagnifierView.this.getResources().getDimension(2131427340);
        }

        void setViewDimensions(int width, int height) {
            this.viewWidth = width;
            this.viewHeight = height;
            if (this.drawable != null && width != 0 && height != 0) {
                this.bitmapScale = Math.max((float)this.drawable.getIntrinsicWidth() / (float)this.viewWidth, (float)this.drawable.getIntrinsicHeight() / (float)this.viewHeight);
                this.offsetX = ((float)this.viewWidth - (float)this.drawable.getIntrinsicWidth() / this.bitmapScale) / 2.0f;
                this.offsetY = ((float)this.viewHeight - (float)this.drawable.getIntrinsicHeight() / this.bitmapScale) / 2.0f;
            }
        }

        void setup(ImageView view) {
            if (this.shader == null && view.getDrawable() != null) {
                this.drawable = (BitmapDrawable)view.getDrawable();
                this.shader = new BitmapShader(this.drawable.getBitmap(), Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                this.shaderPaint.setShader((Shader)this.shader);
                this.rotation = view.getRotation();
                this.setViewDimensions(MagnifierView.this.getWidth(), MagnifierView.this.getHeight());
            }
        }

        void draw(Canvas canvas, PointF zoomPoint) {
            float startX = this.margin;
            float startY = this.margin;
            if (this.isInLeftTop(zoomPoint)) {
                startX = (float)MagnifierView.this.getWidth() - this.radius * 2.0f - this.margin;
            }
            this.matrix.setScale(2.0f, 2.0f);
            this.matrix.postTranslate(-zoomPoint.x * this.bitmapScale * 2.0f + this.radius + startX, -zoomPoint.y * this.bitmapScale * 2.0f + this.radius + startY);
            this.shader.setLocalMatrix(this.matrix);
            canvas.save();
            canvas.rotate(this.rotation, startX + this.radius, startY + this.radius);
            canvas.drawCircle(startX + this.radius, startY + this.radius, this.radius, this.shaderPaint);
            canvas.restore();
            canvas.drawBitmap(MagnifierView.this.magnifierBitmap, startX, startY, null);
        }

        private boolean isInLeftTop(PointF point) {
            int quarter = 1;
            quarter = point.x + this.offsetX < (float)(this.viewWidth >> 1) ? (point.y + this.offsetY < (float)(this.viewHeight >> 1) ? 1 : 4) : (point.y + this.offsetY < (float)(this.viewHeight >> 1) ? 2 : 3);
            quarter = (int)((float)quarter - (360.0f - this.rotation) % 360.0f / 90.0f);
            return quarter == 1;
        }
    }
}

