/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.persistence;

import android.util.SparseArray;

public enum OptimizationType {
    NONE(0, "none"),
    COLOR_ENHANCED(1, "color_enhanced"),
    GRAYSCALE(2, "grayscale"),
    BLACK_AND_WHITE(3, "black_and_white");

    private static final SparseArray<OptimizationType> code2Type;
    private final int code;
    private final String name;

    private OptimizationType(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static OptimizationType getByCode(int code) {
        OptimizationType type = (OptimizationType)((Object)code2Type.get(code));
        if (type == null) {
            throw new IllegalStateException("No Optimization type for code: " + code);
        }
        return type;
    }

    static {
        code2Type = new SparseArray();
        for (OptimizationType type : OptimizationType.values()) {
            code2Type.put(type.getCode(), (Object)type);
        }
    }
}

