/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui;

import android.app.ActionBar;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import net.doo.snap.lib.analytics.ActivityAnalytics;
import net.doo.snap.lib.persistence.Signature;
import net.doo.snap.lib.persistence.SignatureStoreStrategy;
import net.doo.snap.lib.sensor.SensorHelper;
import net.doo.snap.lib.sensor.ShakeListener;
import net.doo.snap.lib.ui.widget.signature.SignatureView;
import net.doo.snap.lib.util.bitmap.BitmapLruCache;
import net.doo.snap.lib.util.bitmap.BitmapUtils;
import net.doo.snap.lib.util.log.DebugLog;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import roboguice.activity.RoboActivity;

public class CreateSignatureActivity
extends RoboActivity {
    public static final String ARG_SIGNATURE_ID = "ARG_SIGNATURE_ID";
    public static final String RESULT_SIGNATURE = "RESULT_SIGNATURE";
    public static final String RESULT_UPDATED_SIGNATURE_ID = "RESULT_UPDATED_SIGNATURE_ID";
    private static final float RESULT_SCALE = 0.5f;
    private static final float MIN_SIGNATURE_DIMENSION_DP = 38.0f;
    private static final String SAVED_SIGNATURE_PATH = "SAVED_SIGNATURE_PATH";
    @Inject
    private SignatureStoreStrategy signatureStoreStrategy;
    @Inject
    private ActivityAnalytics activityAnalytics;
    @Inject
    private SensorHelper sensorHelper;
    @Inject
    private SharedPreferences sharedPreferences;
    @Inject
    private BitmapLruCache bitmapLruCache;
    @Nullable
    private String signatureId;
    private SignatureView signatureView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903040);
        this.signatureId = this.getIntent().getStringExtra(ARG_SIGNATURE_ID);
        ActionBar actionBar = this.getActionBar();
        actionBar.setDisplayShowHomeEnabled(false);
        actionBar.setDisplayShowTitleEnabled(false);
        actionBar.setDisplayShowCustomEnabled(true);
        actionBar.setDisplayHomeAsUpEnabled(false);
        actionBar.setCustomView(2130903050);
        View done = this.findViewById(2131296309);
        done.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                new CreateSignatureTask(CreateSignatureActivity.this.signatureView.getSignature()).execute(new Void[0]);
            }
        });
        this.signatureView = (SignatureView)this.findViewById(2131296278);
        this.sensorHelper.registerSignificantMoveListener(new ShakeListener(){

            @Override
            public void onShake() {
                CreateSignatureActivity.this.signatureView.clear();
            }
        });
        if (TextUtils.isEmpty((CharSequence)this.signatureId) && this.sharedPreferences.contains(SAVED_SIGNATURE_PATH)) {
            new LoadSavedSignatureTask().execute(new Void[0]);
        }
    }

    private void deliverResult(Signature signature) {
        Intent result = new Intent();
        result.putExtra(RESULT_SIGNATURE, (Parcelable)signature);
        if (this.signatureId != null) {
            result.putExtra(RESULT_UPDATED_SIGNATURE_ID, this.signatureId);
        }
        this.setResult(-1, result);
        this.finish();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131623937, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 2131296335) {
            this.signatureView.clear();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private class CreateSignatureTask
    extends AsyncTask<Void, Void, Signature> {
        private Bitmap signatureBitmap;
        private DisplayMetrics displayMetrics;

        private CreateSignatureTask(Bitmap signatureBitmap) {
            this.signatureBitmap = signatureBitmap;
            this.displayMetrics = CreateSignatureActivity.this.getResources().getDisplayMetrics();
        }

        protected Signature doInBackground(Void ... voids) {
            if (this.signatureBitmap == null) {
                CreateSignatureActivity.this.sharedPreferences.edit().putString(CreateSignatureActivity.SAVED_SIGNATURE_PATH, null).apply();
                return null;
            }
            this.rememberSignature();
            this.scaleDownSignature();
            this.cropSignature();
            return this.buildSignature(this.signatureBitmap);
        }

        private void rememberSignature() {
            try {
                File file = CreateSignatureActivity.this.signatureStoreStrategy.getLastDrawnSignatureFile();
                BitmapUtils.compress(this.signatureBitmap, Bitmap.CompressFormat.PNG, 0, file);
                CreateSignatureActivity.this.sharedPreferences.edit().putString(CreateSignatureActivity.SAVED_SIGNATURE_PATH, file.getPath()).apply();
            }
            catch (IOException e) {
                DebugLog.logException(e);
            }
        }

        private void scaleDownSignature() {
            Matrix matrix = new Matrix();
            matrix.setScale(0.5f, 0.5f);
            this.signatureBitmap = Bitmap.createBitmap((Bitmap)this.signatureBitmap, (int)0, (int)0, (int)this.signatureBitmap.getWidth(), (int)this.signatureBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }

        private void cropSignature() {
            int minSize = (int)TypedValue.applyDimension((int)1, (float)38.0f, (DisplayMetrics)this.displayMetrics);
            Rect rect = BitmapUtils.getContentBounds(this.signatureBitmap);
            Bitmap bitmap = Bitmap.createBitmap((int)Math.max(rect.width(), minSize), (int)Math.max(rect.height(), minSize), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawBitmap(this.signatureBitmap, (float)(bitmap.getWidth() - rect.width()) / 2.0f - (float)rect.left, (float)(bitmap.getHeight() - rect.height()) / 2.0f - (float)rect.top, null);
            this.signatureBitmap = bitmap;
        }

        private Signature buildSignature(Bitmap signatureBitmap) {
            if (!BitmapUtils.isBitmapValid(signatureBitmap)) {
                return null;
            }
            Signature signature = new Signature();
            signature.setId(UUID.randomUUID().toString());
            try {
                signature.setImagePath(this.saveSignatureBitmapToFile(signature, signatureBitmap));
            }
            catch (IOException e) {
                DebugLog.logException(e);
                return null;
            }
            signature.setRect(new RectF());
            CreateSignatureActivity.this.bitmapLruCache.remove(signature.getImagePath());
            return signature;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String saveSignatureBitmapToFile(Signature signature, Bitmap signatureBitmap) throws IOException {
            File file = CreateSignatureActivity.this.signatureStoreStrategy.getSignatureFile(signature);
            if (file == null) {
                throw new IOException("Can't open file for signature");
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            try {
                signatureBitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)outputStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            return file.getPath();
        }

        protected void onPostExecute(Signature signature) {
            CreateSignatureActivity.this.deliverResult(signature);
        }
    }

    private class LoadSavedSignatureTask
    extends AsyncTask<Void, Void, Bitmap> {
        private LoadSavedSignatureTask() {
        }

        protected Bitmap doInBackground(Void ... voids) {
            return BitmapFactory.decodeFile((String)CreateSignatureActivity.this.sharedPreferences.getString(CreateSignatureActivity.SAVED_SIGNATURE_PATH, null));
        }

        protected void onPostExecute(Bitmap bitmap) {
            CreateSignatureActivity.this.signatureView.setSignature(bitmap);
        }
    }
}

