package net.doo.snap.lib.billing;

/**
 * Represents a functionality of the app managed by {@link net.doo.snap.lib.billing.BillingManager}.
 *
 * @see net.doo.snap.lib.billing.BillingManager
 * @see net.doo.snap.lib.billing.FeatureExecutor
 */
public abstract class Feature {

    private final String id;

    public Feature(String id) {
        this.id = id;
    }

    /**
     * @return id of app's feature which corresponds to SKU id in billing service
     */
    public String getId() {
        return id;
    }

    /**
     * Implementation of feature itself.
     */
    protected abstract void run();

}
