package net.doo.snap.lib.snap.edit.events;

/**
 * Fired when {@link net.doo.snap.lib.persistence.Page} should be retaken
 */
public class RetakePageEvent {

    private final boolean animate;
    private float dropX;
    private float dropY;

    private final int pagePosition;

    /**
     * Indicates that retake photo action should be animated
     *
     * @param pagePosition position of {@link net.doo.snap.lib.persistence.Page} which should be retaken
     * @param dropX        X position of dropped {@link net.doo.snap.lib.persistence.Page}
     * @param dropY        Y postion of dropped {@link net.doo.snap.lib.persistence.Page}
     */
    public RetakePageEvent(int pagePosition, float dropX, float dropY) {
        this.animate = true;
        this.pagePosition = pagePosition;
        this.dropX = dropX;
        this.dropY = dropY;
    }

    /**
     * Indicates that rekate photo action should be performed without animation
     *
     * @param pagePosition position of {@link net.doo.snap.lib.persistence.Page} which should be retaken
     */
    public RetakePageEvent(int pagePosition) {
        this.animate = false;
        this.pagePosition = pagePosition;
    }

    /**
     * @return indicates whether retake photo action should be animated or not.
     */
    public boolean shouldAnimate() {
        return animate;
    }

    /**
     * @return X position of dropped {@link net.doo.snap.lib.persistence.Page} or 0f if no animation should be
     * performed
     */
    public float getDropX() {
        return dropX;
    }

    /**
     * @return Y position of dropped {@link net.doo.snap.lib.persistence.Page} or 0f if no animation should be
     * performed
     */
    public float getDropY() {
        return dropY;
    }

    /**
     * @return position of {@link net.doo.snap.lib.persistence.Page} which should be retaken
     */
    public int getPagePosition() {
        return pagePosition;
    }
}
