/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.neetutils.dispose;

public class ReferenceList<T> {
    private Node<T> root;
    private int size;

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Node<T> add(T value) {
        Node<T> node = new Node<T>(value);
        ++this.size;
        if (this.root != null) {
            node.next = this.root;
            this.root.previous = node;
        }
        this.root = node;
        return node;
    }

    public Node<T> removeLast() {
        if (this.root == null) {
            return null;
        }
        --this.size;
        Node<T> node = this.root;
        if (node.next != null) {
            node.next.previous = null;
        }
        this.root = node.next;
        node.previous = null;
        node.next = null;
        node.inside = false;
        return node;
    }

    public void remove(Node<T> node) {
        if (!node.inside) {
            return;
        }
        --this.size;
        if (node.previous == null) {
            this.root = node.next;
        } else {
            node.previous.next = node.next;
            if (node.next != null) {
                node.next.previous = node.previous;
            }
        }
        node.previous = null;
        node.next = null;
        node.inside = false;
    }

    public static class Node<T> {
        final T value;
        boolean inside = true;
        Node<T> previous;
        Node<T> next;

        public Node(T value) {
            this.value = value;
        }

        public T value() {
            return this.value;
        }

        public String toString() {
            return "Node: " + this.value;
        }
    }
}

