/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.exif;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

class CountedDataInputStream
extends FilterInputStream {
    private int mCount = 0;
    private final byte[] mByteArray = new byte[8];
    private final ByteBuffer mByteBuffer = ByteBuffer.wrap(this.mByteArray);

    protected CountedDataInputStream(InputStream in) {
        super(in);
    }

    public int getReadByteCount() {
        return this.mCount;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.in.read(b);
        this.mCount += r >= 0 ? r : 0;
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        this.mCount += r >= 0 ? r : 0;
        return r;
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        this.mCount += r >= 0 ? 1 : 0;
        return r;
    }

    @Override
    public long skip(long length) throws IOException {
        long skip = this.in.skip(length);
        this.mCount = (int)((long)this.mCount + skip);
        return skip;
    }

    public void skipOrThrow(long length) throws IOException {
        if (this.skip(length) != length) {
            throw new EOFException();
        }
    }

    public void skipTo(long target) throws IOException {
        long cur = this.mCount;
        long diff = target - cur;
        assert (diff >= 0L);
        this.skipOrThrow(diff);
    }

    public void readOrThrow(byte[] b, int off, int len) throws IOException {
        int r = this.read(b, off, len);
        if (r != len) {
            throw new EOFException();
        }
    }

    public void readOrThrow(byte[] b) throws IOException {
        this.readOrThrow(b, 0, b.length);
    }

    public void setByteOrder(ByteOrder order) {
        this.mByteBuffer.order(order);
    }

    public ByteOrder getByteOrder() {
        return this.mByteBuffer.order();
    }

    public short readShort() throws IOException {
        this.readOrThrow(this.mByteArray, 0, 2);
        this.mByteBuffer.rewind();
        return this.mByteBuffer.getShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public int readInt() throws IOException {
        this.readOrThrow(this.mByteArray, 0, 4);
        this.mByteBuffer.rewind();
        return this.mByteBuffer.getInt();
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() throws IOException {
        this.readOrThrow(this.mByteArray, 0, 8);
        this.mByteBuffer.rewind();
        return this.mByteBuffer.getLong();
    }

    public String readString(int n) throws IOException {
        byte[] buf = new byte[n];
        this.readOrThrow(buf);
        return new String(buf, "UTF8");
    }

    public String readString(int n, Charset charset) throws IOException {
        byte[] buf = new byte[n];
        this.readOrThrow(buf);
        return new String(buf, charset);
    }
}

