package net.doo.snap.lib.ui.widget.text.processor;

import android.graphics.Typeface;
import android.text.SpannableStringBuilder;
import android.text.Spanned;

import net.doo.snap.lib.ui.widget.text.CustomTypefaceSpan;

/**
 * Formats input with stressing typeface.
 * <p/>
 * Format rules:
 * - Text between stars (symbol: '*') assigned a "stressed" {@link android.graphics.Typeface}
 */
public class StressedProcessStrategy implements TextProcessor.ProcessStrategy {

    private static final char STRESS_SIGN = '*';

    private final Typeface stressed;

    Integer spanStart = null;

    public StressedProcessStrategy(Typeface stressed) {
        this.stressed = stressed;
    }

    @Override
    public boolean processChar(char currentChar, SpannableStringBuilder output) {
        if (currentChar == STRESS_SIGN) {
            if (spanStart == null) {
                spanStart = output.length();
            } else {
                output.setSpan(
                        new CustomTypefaceSpan(stressed),
                        spanStart,
                        output.length(),
                        Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
                );

                spanStart = null;
            }

            return true;
        }

        final boolean consumed = (spanStart != null);

        if (consumed) {
            output.append(currentChar);
        }

        return consumed;
    }

    @Override
    public void reset() {
        spanStart = null;
    }

}
