/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.CameraHostProvider;
import com.commonsware.cwac.camera.ImageCleanupTask;
import com.commonsware.cwac.camera.PictureTransaction;
import com.commonsware.cwac.camera.PreviewStrategy;
import com.commonsware.cwac.camera.SurfacePreviewStrategy;
import com.commonsware.cwac.camera.TexturePreviewStrategy;
import com.commonsware.cwac.camera.ZoomTransaction;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class CameraView
extends ViewGroup
implements Camera.AutoFocusCallback {
    private static final int[] ROTATION_DEGREES = new int[]{0, 90, 180, 270};
    private static final int UPDATE_RATE_US = 200000;
    static final String TAG = "CWAC-Camera";
    private PreviewStrategy previewStrategy;
    private Camera.Size previewSize;
    private Camera camera = null;
    private boolean inPreview = false;
    private CameraHost host = null;
    private OnOrientationChange onOrientationChange = null;
    private int displayOrientation = -1;
    private int outputOrientation = -1;
    private int cameraId = -1;
    private MediaRecorder recorder = null;
    private Camera.Parameters previewParams = null;
    private boolean isDetectingFaces = false;
    private boolean isAutoFocusing = false;
    private Camera.PreviewCallback previewCallback;
    private static final Executor cameraExecutor = Executors.newSingleThreadExecutor();

    public CameraView(Context context) {
        super(context);
        this.onOrientationChange = new OnOrientationChange(context);
    }

    public CameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.onOrientationChange = new OnOrientationChange(context);
        if (!(context instanceof CameraHostProvider)) {
            throw new IllegalArgumentException("To use the two- or three-parameter constructors on CameraView, your activity needs to implement the CameraHostProvider interface");
        }
        this.setHost(((CameraHostProvider)context).getCameraHost());
    }

    public CameraHost getHost() {
        return this.host;
    }

    public void setHost(CameraHost host) {
        this.host = host;
        this.previewStrategy = host.getDeviceProfile().useTextureView() ? new TexturePreviewStrategy(this) : new SurfacePreviewStrategy(this);
    }

    public Camera.Parameters getCameraParameters() {
        return this.previewParams;
    }

    public void setCameraParameters(final Camera.Parameters parameters) {
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                CameraView.this.setCameraParametersSync(parameters);
            }
        });
    }

    private void setCameraParametersSync(Camera.Parameters parameters) {
        try {
            if (this.camera != null && parameters != null) {
                this.camera.setParameters(parameters);
            }
            this.previewParams = parameters;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private Camera.Parameters getCameraParametersSync() {
        if (this.camera != null) {
            try {
                this.previewParams = this.camera.getParameters();
            }
            catch (RuntimeException e) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Could not work with camera parameters?", (Throwable)e);
            }
        }
        return this.previewParams;
    }

    public void onCameraOpen(Camera camera) throws RuntimeException {
        if (this.getActivity().getRequestedOrientation() != -1) {
            this.onOrientationChange.enable();
        }
        this.setCameraDisplayOrientation();
        if (Build.VERSION.SDK_INT >= 14 && this.getHost() instanceof Camera.FaceDetectionListener) {
            camera.setFaceDetectionListener((Camera.FaceDetectionListener)this.getHost());
        }
        this.setPreviewCallback(this.previewCallback);
    }

    @TargetApi(value=14)
    public void onResume() {
        this.onOrientationChange.resetOrientation();
        this.addView(this.previewStrategy.getWidget());
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.camera == null) {
                    CameraView.this.cameraId = CameraView.this.getHost().getCameraId();
                    if (CameraView.this.cameraId >= 0) {
                        try {
                            CameraView.this.camera = Camera.open((int)CameraView.this.cameraId);
                            CameraView.this.getCameraParametersSync();
                            CameraView.this.onCameraOpen(CameraView.this.camera);
                        }
                        catch (Exception e) {
                            CameraView.this.getHost().onCameraFail(CameraHost.FailureReason.UNKNOWN);
                        }
                    } else {
                        CameraView.this.getHost().onCameraFail(CameraHost.FailureReason.NO_CAMERAS_REPORTED);
                    }
                }
            }
        });
    }

    public void onPause() {
        this.previewDestroyed();
        if (this.previewStrategy.getWidget() != null) {
            this.removeView(this.previewStrategy.getWidget());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = CameraView.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = CameraView.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        if (width > 0 && height > 0 && this.camera != null && this.getCameraParameters() != null) {
            Camera.Size newSize = null;
            try {
                if (this.getHost().getRecordingHint() != CameraHost.RecordingHint.STILL_ONLY) {
                    newSize = this.getHost().getPreferredPreviewSizeForVideo(this.getDisplayOrientation(), width, height, this.getCameraParameters(), null);
                }
                if (newSize == null || newSize.width * newSize.height < 65536) {
                    newSize = this.getHost().getPreviewSize(this.getDisplayOrientation(), width, height, this.getCameraParameters());
                }
            }
            catch (Exception e) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Could not work with camera parameters?", (Throwable)e);
            }
            if (newSize != null) {
                if (this.previewSize == null) {
                    this.previewSize = newSize;
                } else if (this.previewSize.width != newSize.width || this.previewSize.height != newSize.height) {
                    if (this.inPreview) {
                        this.stopPreview();
                    }
                    this.previewSize = newSize;
                    this.initPreview(width, height, false);
                }
            }
        }
    }

    public Camera.Size getPreviewSize() {
        return this.previewSize;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            int width = r - l;
            int height = b - t;
            int previewWidth = width;
            int previewHeight = height;
            if (this.previewSize != null && this.previewSize.height > 0 && this.previewSize.width > 0) {
                if (this.getDisplayOrientation() == 90 || this.getDisplayOrientation() == 270) {
                    previewWidth = this.previewSize.height;
                    previewHeight = this.previewSize.width;
                } else {
                    previewWidth = this.previewSize.width;
                    previewHeight = this.previewSize.height;
                }
            }
            if (previewWidth == 0 || previewHeight == 0) {
                return;
            }
            boolean useFirstStrategy = width * previewHeight > height * previewWidth;
            boolean useFullBleed = this.getHost().useFullBleedPreview();
            if (useFirstStrategy && !useFullBleed || !useFirstStrategy && useFullBleed) {
                int scaledChildWidth = previewWidth * height / previewHeight;
                child.layout((width - scaledChildWidth) / 2, 0, (width + scaledChildWidth) / 2, height);
            } else {
                int scaledChildHeight = previewHeight * width / previewWidth;
                child.layout(0, (height - scaledChildHeight) / 2, width, (height + scaledChildHeight) / 2);
            }
        }
    }

    public int getDisplayOrientation() {
        return this.displayOrientation;
    }

    public void lockToLandscape(boolean enable) {
        if (enable) {
            this.getActivity().setRequestedOrientation(6);
            this.onOrientationChange.enable();
        } else {
            this.getActivity().setRequestedOrientation(-1);
            this.onOrientationChange.disable();
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                CameraView.this.setCameraDisplayOrientation();
            }
        });
    }

    public void restartPreview() {
        if (!this.inPreview) {
            this.startPreview();
        }
    }

    public void takePicture(boolean needBitmap, boolean needByteArray) {
        PictureTransaction xact = new PictureTransaction(this.getHost());
        this.takePicture(xact.needBitmap(needBitmap).needByteArray(needByteArray));
    }

    public void takePicture(final PictureTransaction xact) {
        Camera.Parameters pictureParams;
        if (this.inPreview) {
            if (this.isAutoFocusing) {
                throw new IllegalStateException("Camera cannot take a picture while auto-focusing");
            }
            this.getCameraParametersSync();
            pictureParams = this.camera.getParameters();
            Camera.Size pictureSize = xact.host.getPictureSize(xact, pictureParams);
            pictureParams.setPictureSize(pictureSize.width, pictureSize.height);
            pictureParams.setPictureFormat(256);
            if (xact.flashMode != null) {
                pictureParams.setFlashMode(xact.flashMode);
            }
            if (!this.onOrientationChange.isEnabled()) {
                this.setCameraPictureOrientation(pictureParams);
            }
        } else {
            throw new IllegalStateException("Preview mode must have started before you can take a picture");
        }
        this.camera.setParameters(xact.host.adjustPictureParameters(xact, pictureParams));
        xact.cameraView = this;
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                CameraView.this.takePictureAsync(xact);
            }
        }, xact.host.getDeviceProfile().getPictureDelay());
        this.inPreview = false;
    }

    private void takePictureAsync(final PictureTransaction xact) {
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.camera != null) {
                    try {
                        CameraView.this.camera.takePicture((Camera.ShutterCallback)xact, null, (Camera.PictureCallback)new PictureTransactionCallback(xact));
                    }
                    catch (Exception e) {
                        Log.e((String)this.getClass().getSimpleName(), (String)"Exception taking a picture", (Throwable)e);
                    }
                }
            }
        });
    }

    public boolean isRecording() {
        return this.recorder != null;
    }

    public void record() throws Exception {
        if (Build.VERSION.SDK_INT < 11) {
            throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
        }
        if (this.displayOrientation != 0 && this.displayOrientation != 180) {
            throw new UnsupportedOperationException("Video recording supported only in landscape");
        }
        Camera.Parameters pictureParams = this.camera.getParameters();
        this.setCameraPictureOrientation(pictureParams);
        this.camera.setParameters(pictureParams);
        this.stopPreview();
        this.camera.unlock();
        try {
            this.recorder = new MediaRecorder();
            this.recorder.setCamera(this.camera);
            this.getHost().configureRecorderAudio(this.cameraId, this.recorder);
            this.recorder.setVideoSource(1);
            this.getHost().configureRecorderProfile(this.cameraId, this.recorder);
            this.getHost().configureRecorderOutput(this.cameraId, this.recorder);
            this.recorder.setOrientationHint(this.outputOrientation);
            this.previewStrategy.attach(this.recorder);
            this.recorder.prepare();
            this.recorder.start();
        }
        catch (IOException e) {
            this.recorder.release();
            this.recorder = null;
            throw e;
        }
    }

    public void stopRecording() throws IOException {
        if (Build.VERSION.SDK_INT < 11) {
            throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
        }
        MediaRecorder tempRecorder = this.recorder;
        this.recorder = null;
        tempRecorder.stop();
        tempRecorder.release();
        this.camera.reconnect();
    }

    public void autoFocus() {
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.inPreview && CameraView.this.camera != null) {
                    try {
                        CameraView.this.camera.autoFocus((Camera.AutoFocusCallback)CameraView.this);
                        CameraView.this.isAutoFocusing = true;
                    }
                    catch (RuntimeException e) {
                        Log.e((String)this.getClass().getSimpleName(), (String)"Could not auto focus?", (Throwable)e);
                    }
                }
            }
        });
    }

    public void cancelAutoFocus() {
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.camera != null) {
                    CameraView.this.camera.cancelAutoFocus();
                }
            }
        });
    }

    public boolean isAutoFocusAvailable() {
        return this.inPreview;
    }

    public void onAutoFocus(boolean success, Camera camera) {
        this.isAutoFocusing = false;
        if (this.getHost() instanceof Camera.AutoFocusCallback) {
            this.getHost().onAutoFocus(success, camera);
        }
    }

    public String getFlashMode() {
        return this.getCameraParameters().getFlashMode();
    }

    public void setFlashMode(final String mode) {
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.camera != null) {
                    Camera.Parameters params = CameraView.this.getCameraParametersSync();
                    params.setFlashMode(mode);
                    CameraView.this.setCameraParametersSync(params);
                }
            }
        });
    }

    public ZoomTransaction zoomTo(int level) {
        if (this.camera == null) {
            throw new IllegalStateException("Yes, we have no camera, we have no camera today");
        }
        Camera.Parameters params = this.getCameraParametersSync();
        if (level >= 0 && level <= params.getMaxZoom()) {
            return new ZoomTransaction(this.camera, level);
        }
        throw new IllegalArgumentException(String.format("Invalid zoom level: %d", level));
    }

    @TargetApi(value=14)
    public void startFaceDetection() {
        if (Build.VERSION.SDK_INT >= 14 && this.camera != null && !this.isDetectingFaces && this.getCameraParametersSync().getMaxNumDetectedFaces() > 0) {
            this.camera.startFaceDetection();
            this.isDetectingFaces = true;
        }
    }

    public void stopFaceDetection() {
        if (Build.VERSION.SDK_INT >= 14 && this.camera != null && this.isDetectingFaces) {
            this.camera.stopFaceDetection();
            this.isDetectingFaces = false;
        }
    }

    public void setPreviewCallback(Camera.PreviewCallback callback) {
        this.previewCallback = callback;
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.camera != null) {
                    try {
                        if (CameraView.this.getHost().getDeviceProfile().isCustomRom()) {
                            CameraView.this.camera.setPreviewCallback(CameraView.this.previewCallback);
                        } else {
                            CameraView.this.camera.setPreviewCallbackWithBuffer(CameraView.this.previewCallback);
                        }
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void addPreviewCallbackBuffer(final byte[] buffer) {
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.camera != null && buffer != null) {
                    CameraView.this.camera.addCallbackBuffer(buffer);
                }
            }
        });
    }

    public boolean doesZoomReallyWork() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.getHost().getCameraId(), (Camera.CameraInfo)info);
        return this.getHost().getDeviceProfile().doesZoomActuallyWork(info.facing == 1);
    }

    void previewCreated() {
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.camera != null) {
                    try {
                        CameraView.this.previewStrategy.attach(CameraView.this.camera);
                    }
                    catch (IOException e) {
                        CameraView.this.getHost().handleException(e);
                    }
                }
            }
        });
    }

    void previewDestroyed() {
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.camera != null) {
                    CameraView.this.previewStopped();
                    CameraView.this.camera.setPreviewCallback(null);
                    CameraView.this.camera.release();
                    CameraView.this.camera = null;
                }
            }
        });
    }

    void previewReset(int width, int height) {
        this.previewStopped();
        this.initPreview(width, height);
    }

    private void previewStopped() {
        if (this.inPreview) {
            this.stopPreview();
        }
    }

    public void initPreview(int w, int h) {
        this.initPreview(w, h, true);
    }

    @TargetApi(value=14)
    public void initPreview(final int w, final int h, boolean firstRun) {
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.camera != null) {
                    Camera.Parameters parameters = CameraView.this.getCameraParametersSync();
                    if (CameraView.this.previewSize == null) {
                        CameraView.this.previewSize = CameraView.this.getHost().getPreviewSize(CameraView.this.getDisplayOrientation(), w, h, parameters);
                    }
                    parameters.setPreviewSize(((CameraView)CameraView.this).previewSize.width, ((CameraView)CameraView.this).previewSize.height);
                    if (Build.VERSION.SDK_INT >= 14) {
                        parameters.setRecordingHint(CameraView.this.getHost().getRecordingHint() != CameraHost.RecordingHint.STILL_ONLY);
                    }
                    CameraView.this.setCameraParametersSync(CameraView.this.getHost().adjustPreviewParameters(parameters));
                    CameraView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            CameraView.this.requestLayout();
                        }
                    });
                    CameraView.this.startPreview();
                }
            }
        });
    }

    public void startPreview() {
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                CameraView.this.startPreviewSync();
            }
        });
    }

    private void startPreviewSync() {
        try {
            if (this.camera != null) {
                this.camera.startPreview();
                this.inPreview = true;
                this.getHost().autoFocusAvailable();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void stopPreview() {
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                CameraView.this.stopPreviewSync();
            }
        });
    }

    private void stopPreviewSync() {
        try {
            if (this.camera != null) {
                this.inPreview = false;
                this.getHost().autoFocusUnavailable();
                this.camera.setPreviewCallback(null);
                this.camera.stopPreview();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void setCameraDisplayOrientation() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        int rotation = this.getActivity().getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        DisplayMetrics dm = new DisplayMetrics();
        Camera.getCameraInfo((int)this.cameraId, (Camera.CameraInfo)info);
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            this.displayOrientation = (info.orientation + degrees) % 360;
            this.displayOrientation = (360 - this.displayOrientation) % 360;
        } else {
            this.displayOrientation = (info.orientation - degrees + 360) % 360;
        }
        cameraExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (CameraView.this.camera != null) {
                    boolean wasInPreview = CameraView.this.inPreview;
                    if (CameraView.this.inPreview) {
                        CameraView.this.stopPreviewSync();
                    }
                    CameraView.this.camera.setDisplayOrientation(CameraView.this.displayOrientation);
                    if (wasInPreview) {
                        CameraView.this.startPreviewSync();
                    }
                }
            }
        });
    }

    private void setCameraPictureOrientation(Camera.Parameters params) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.cameraId, (Camera.CameraInfo)info);
        this.outputOrientation = this.getActivity().getRequestedOrientation() != -1 ? this.getCameraPictureRotation(this.getActivity().getWindowManager().getDefaultDisplay().getOrientation()) : (info.facing == 1 ? (360 - this.displayOrientation) % 360 : this.displayOrientation);
        params.setRotation(this.outputOrientation);
    }

    private int getCameraPictureRotation(int orientation) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.cameraId, (Camera.CameraInfo)info);
        int rotation = 0;
        orientation = (orientation + 45) / 90 * 90;
        rotation = info.facing == 1 ? (info.orientation - orientation + 360) % 360 : (info.orientation + orientation) % 360;
        return rotation;
    }

    Activity getActivity() {
        return (Activity)this.getContext();
    }

    private class PictureTransactionCallback
    implements Camera.PictureCallback {
        PictureTransaction xact = null;

        PictureTransactionCallback(PictureTransaction xact) {
            this.xact = xact;
        }

        public void onPictureTaken(byte[] data, Camera camera) {
            if (CameraView.this.previewParams != null && camera != null) {
                try {
                    camera.setParameters(CameraView.this.previewParams);
                }
                catch (RuntimeException e) {
                    Log.e((String)this.getClass().getSimpleName(), (String)"Could not set camera parameters!", (Throwable)e);
                }
            }
            if (data != null) {
                new ImageCleanupTask(CameraView.this.getContext(), data, CameraView.this.cameraId, this.xact).start();
            }
            if (!this.xact.useSingleShotMode()) {
                CameraView.this.startPreview();
            }
        }
    }

    private class OnOrientationChange
    extends OrientationEventListener {
        private int currentOrientation;
        private boolean isEnabled;

        public OnOrientationChange(Context context) {
            super(context, 200000);
            this.currentOrientation = -1;
            this.isEnabled = false;
            this.disable();
        }

        public void resetOrientation() {
            this.currentOrientation = -1;
        }

        public void onOrientationChanged(int orientation) {
            if (CameraView.this.camera == null || !this.canDetectOrientation() || orientation == -1) {
                return;
            }
            if ((orientation = this.getClosestRotationDegree(orientation)) != this.currentOrientation) {
                CameraView.this.outputOrientation = CameraView.this.getCameraPictureRotation(orientation);
                Camera.Parameters params = CameraView.this.getCameraParametersSync();
                params.setRotation(CameraView.this.outputOrientation);
                try {
                    CameraView.this.setCameraParametersSync(params);
                    this.currentOrientation = orientation;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }

        private int getClosestRotationDegree(int rotation) {
            for (int value : ROTATION_DEGREES) {
                int diff = Math.abs(rotation - value);
                if (diff >= 45) continue;
                return value;
            }
            return 0;
        }

        public void enable() {
            this.isEnabled = true;
            super.enable();
        }

        public void disable() {
            this.isEnabled = false;
            super.disable();
        }

        boolean isEnabled() {
            return this.isEnabled;
        }
    }
}

