/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.app.ActionBar;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.DragEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.lib.analytics.EasyTrackerWrapper;
import net.doo.snap.lib.edit.EditPolygonActivity;
import net.doo.snap.lib.genuineness.GenuinenessChecker;
import net.doo.snap.lib.persistence.DocumentDraft;
import net.doo.snap.lib.persistence.OptimizationType;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PageStoreStrategy;
import net.doo.snap.lib.persistence.PictureProcessor;
import net.doo.snap.lib.persistence.RotationType;
import net.doo.snap.lib.smartname.SmartNameGenerator;
import net.doo.snap.lib.snap.PreviewFragmentPagerAdapter;
import net.doo.snap.lib.snap.SaveModeFragment;
import net.doo.snap.lib.snap.camera.CameraActivity;
import net.doo.snap.lib.snap.camera.CameraPreviewFragment;
import net.doo.snap.lib.snap.edit.ChangeFilterFragment;
import net.doo.snap.lib.snap.edit.DeletePageEditor;
import net.doo.snap.lib.snap.edit.EditLock;
import net.doo.snap.lib.snap.edit.PagesEditor;
import net.doo.snap.lib.snap.edit.RenameDocumentFragment;
import net.doo.snap.lib.snap.edit.RotatePageEditor;
import net.doo.snap.lib.snap.edit.drag.PagesRearranger;
import net.doo.snap.lib.snap.edit.events.DeletePageEvent;
import net.doo.snap.lib.snap.edit.events.DocumentRenamedEvent;
import net.doo.snap.lib.snap.edit.events.RetakePageEvent;
import net.doo.snap.lib.snap.edit.events.RotatePageEvent;
import net.doo.snap.lib.snap.event.CheckGenuinenessEvent;
import net.doo.snap.lib.snap.event.PageOptimizationTypeChangedEvent;
import net.doo.snap.lib.snap.event.PagesChangedEvent;
import net.doo.snap.lib.snap.event.PictureProcessingStatusChangedEvent;
import net.doo.snap.lib.snap.event.PictureTakenEvent;
import net.doo.snap.lib.snap.event.ProcessDocumentsEvent;
import net.doo.snap.lib.snap.event.SaveDocumentEvent;
import net.doo.snap.lib.snap.preview.zoom.PrepareZoomEvent;
import net.doo.snap.lib.snap.preview.zoom.ZoomingFinishedEvent;
import net.doo.snap.lib.ui.BarcodeFragment;
import net.doo.snap.lib.ui.events.OnPageLongPressedEvent;
import net.doo.snap.lib.ui.tutorial.AddNewPageTutorialFragment;
import net.doo.snap.lib.ui.tutorial.RearrangementTutorialFragment;
import net.doo.snap.lib.ui.widget.MultiStateImageButton;
import net.doo.snap.lib.ui.widget.ViewPager;
import net.doo.snap.lib.util.bitmap.BitmapLruCache;
import net.doo.snap.lib.util.log.DebugLog;
import net.doo.snap.lib.util.ui.ViewUtils;
import roboguice.activity.RoboFragmentActivity;
import roboguice.activity.event.OnActivityResultEvent;
import roboguice.event.EventManager;
import roboguice.event.EventThread;
import roboguice.event.Observes;
import roboguice.fragment.RoboFragment;

public class SnappingFragment
extends RoboFragment {
    private static final long RETAKE_PHOTO_PLACEHOLDER_SCALE_DURATION_MILLIS = 300L;
    public static final String DOCUMENT_DRAFT = "DOCUMENT_DRAFT";
    public static final String DOCUMENT_NAME_UPDATES = "DOCUMENT_NAME_UPDATES";
    public static final float PAGE_OPENED_PROGRESS = 1.0f;
    private static final float CAMERA_PREVIEW_PRESCALE = 1.4f;
    private static final float CAMERA_PREVIEW_SCALE = 0.7f;
    public static final int EDIT_ACTIVITY_REQUEST_CODE = 18;
    public static final int RETAKE_PHOTO_REQUEST_CODE = 19;
    public static final String SAVE_TYPE_FRAGMENT_TAG = "SAVE_TYPE_FRAGMENT_TAG";
    public static final String RENAME_DOCUMENT_FRAGMENT_TAG = "RENAME_DOCUMENT_FRAGMENT_TAG";
    private static final int ADD_NEW_PAGE_TUTORIAL_PAGES_COUNT = 1;
    private static final int REARRANGEMENT_TUTORIAL_PAGES_COUNT = 3;
    private static final float PAGE_TRANSFORMATION_DELTA = 0.005f;
    private static final String CHANGE_FILTER_FRAGMENT_TAG = "CHANGE_FILTER_FRAGMENT_TAG";
    @Inject
    private EventManager eventManager;
    @Inject
    private PreviewFragmentPagerAdapter adapter;
    @Inject
    private PageStoreStrategy pageStoreStrategy;
    @Inject
    private PictureProcessor pictureProcessor;
    @Inject
    private EditLock editLock;
    @Inject
    private SharedPreferences preferences;
    @Inject
    private BitmapLruCache bitmapLruCache;
    @Inject
    private GenuinenessChecker checker;
    @Inject
    private SmartNameGenerator smartNameBuilder;
    @Inject
    private PagesRearranger pagesRearranger;
    @Inject
    private DeletePageEditor deletePageEditor;
    @Inject
    private RotatePageEditor rotatePageEditor;
    private final Handler handler = new Handler();
    private View rootView;
    private ViewPager pager;
    private View bottomBar;
    private View retakeCameraPlaceholder;
    private ImageView snappedPreview;
    private Drawable actionBarBackground;
    private boolean animatingRetakePhoto = false;
    private final DataSetObserver pagesObserver = new DataSetObserver(){

        public void onChanged() {
            super.onChanged();
            SnappingFragment.this.notifyPagesChanged();
            SnappingFragment.this.getActivity().invalidateOptionsMenu();
        }

        public void onInvalidated() {
            super.onInvalidated();
            SnappingFragment.this.notifyPagesChanged();
            SnappingFragment.this.getActivity().invalidateOptionsMenu();
        }
    };
    private MultiStateImageButton filterButton;
    private boolean docNameUpdatesEnabled = true;

    public SnappingFragment() {
        this.setHasOptionsMenu(true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(2130903069, container, false);
        this.actionBarBackground = this.getResources().getDrawable(2131230743);
        this.getSupportActionBar().setBackgroundDrawable(this.actionBarBackground);
        this.restoreState(savedInstanceState);
        this.pager = (ViewPager)this.rootView.findViewById(2131296340);
        this.bottomBar = this.rootView.findViewById(2131296342);
        this.retakeCameraPlaceholder = this.rootView.findViewById(2131296299);
        this.snappedPreview = (ImageView)this.rootView.findViewById(2131296343);
        this.pager = (ViewPager)this.rootView.findViewById(2131296340);
        this.pager.setPageMargin(this.getResources().getDimensionPixelSize(2131427332));
        this.pager.setPageTransformer(false, new ViewPager.PageTransformer(){

            @Override
            public void transformPage(View page, float position) {
                if (SnappingFragment.this.adapter.isViewFromObject(page, (Object)SnappingFragment.this.adapter.getCameraFragment())) {
                    float cameraPosition;
                    if (position < 0.005f) {
                        position = 0.0f;
                    }
                    if ((cameraPosition = (0.7f - position) / 0.7f) < 0.0f) {
                        cameraPosition = 0.0f;
                    }
                    SnappingFragment.this.onCameraPageTransformation(page, cameraPosition);
                }
            }
        });
        this.pager.setAdapter(this.adapter);
        this.pager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            @Override
            public void onPageSelected(int position) {
                boolean cameraVisible = SnappingFragment.this.currentPageIsCamera();
                SnappingFragment.this.eventManager.fire((Object)new PagesChangedEvent(SnappingFragment.this.adapter.getDocumentDraft(), cameraVisible));
                if (!cameraVisible) {
                    Page currentPage = SnappingFragment.this.adapter.getDocumentDraft().getPage(position);
                    SnappingFragment.this.filterButton.setCurrentState(currentPage.getOptimizationType().ordinal());
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {
            }
        });
        this.adapter.registerDataSetObserver(this.pagesObserver);
        this.attachPageEditors();
        this.filterButton = (MultiStateImageButton)this.rootView.findViewById(2131296295);
        this.initFilterButton(this.filterButton);
        View trash = this.rootView.findViewById(2131296297);
        trash.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SnappingFragment.this.currentPageIsCamera()) {
                    return;
                }
                SnappingFragment.this.eventManager.fire((Object)new DeletePageEvent());
                EasyTrackerWrapper.sendEvent("ui", "button_press", "delete_page_button", 0L);
            }
        });
        View rotate = this.rootView.findViewById(2131296294);
        rotate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SnappingFragment.this.currentPageIsCamera()) {
                    return;
                }
                SnappingFragment.this.eventManager.fire((Object)new RotatePageEvent());
                EasyTrackerWrapper.sendEvent("ui", "button_press", "rotate_page_button", 0L);
            }
        });
        View crop = this.rootView.findViewById(2131296296);
        crop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SnappingFragment.this.currentPageIsCamera()) {
                    return;
                }
                int position = SnappingFragment.this.pager.getCurrentItem();
                Intent intent = new Intent((Context)SnappingFragment.this.getActivity(), EditPolygonActivity.class);
                intent.putExtra("page", (Parcelable)SnappingFragment.this.adapter.getDocumentDraft().getPage(position));
                SnappingFragment.this.startActivityForResult(intent, 18);
            }
        });
        this.setupDragListener();
        return this.rootView;
    }

    private void initFilterButton(final MultiStateImageButton filter) {
        boolean cameraVisible;
        filter.addState(OptimizationType.NONE.ordinal(), 2130837599).addState(OptimizationType.COLOR_ENHANCED.ordinal(), 2130837602).addState(OptimizationType.BLACK_AND_WHITE.ordinal(), 2130837597).addState(OptimizationType.GRAYSCALE.ordinal(), 2130837601);
        int currentItem = this.pager.getCurrentItem();
        boolean bl = cameraVisible = currentItem == this.adapter.getCount() - 1;
        if (!cameraVisible) {
            Page currentPage = this.adapter.getDocumentDraft().getPage(currentItem);
            filter.setCurrentState(currentPage.getOptimizationType().ordinal());
        }
        filter.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                return SnappingFragment.this.editLock.isEditLocked();
            }
        });
        filter.setOnStateChangedListener(new MultiStateImageButton.OnStateChangedListener(){

            @Override
            public boolean onStateChange(int newState) {
                if (SnappingFragment.this.editLock.isEditLocked() || SnappingFragment.this.currentPageIsCamera()) {
                    return false;
                }
                Page currentPage = SnappingFragment.this.adapter.getDocumentDraft().getPage(SnappingFragment.this.pager.getCurrentItem());
                ChangeFilterFragment.newInstance(currentPage, (View)filter, 2131296340).show(SnappingFragment.this.getFragmentManager(), SnappingFragment.CHANGE_FILTER_FRAGMENT_TAG);
                EasyTrackerWrapper.sendEvent("ui", "button_press", "image_filter_button", Long.valueOf(newState));
                return false;
            }
        });
    }

    private void onPageOptimizationTypeChanged(@Observes PageOptimizationTypeChangedEvent event) {
        OptimizationType optimizationType = event.getOptimizationType();
        Page currentPage = this.adapter.getDocumentDraft().getPage(this.pager.getCurrentItem());
        currentPage.setOptimizationType(optimizationType);
        this.filterButton.setCurrentState(optimizationType.ordinal());
        this.preferences.edit().putInt("LAST_USED_FILTER", optimizationType.getCode()).commit();
    }

    private void notifyPagesChanged() {
        this.eventManager.fire((Object)new PagesChangedEvent(this.adapter.getDocumentDraft(), this.pager.getCurrentItem() == this.adapter.getCount() - 1));
    }

    public void onResume() {
        super.onResume();
        this.repairCameraState();
        this.notifyPagesChanged();
    }

    private void repairCameraState() {
        this.pager.post(new Runnable(){

            @Override
            public void run() {
                final int item = SnappingFragment.this.pager.getCurrentItem();
                SnappingFragment.this.pager.setCurrentItem(SnappingFragment.this.adapter.getCount() - 1, false);
                SnappingFragment.this.pager.post(new Runnable(){

                    @Override
                    public void run() {
                        SnappingFragment.this.pager.setCurrentItem(item, false);
                    }
                });
            }
        });
    }

    @TargetApi(value=11)
    private void setupDragListener() {
        class DragListener
        implements View.OnDragListener {
            DragListener() {
            }

            public boolean onDrag(View v, DragEvent event) {
                switch (event.getAction()) {
                    case 1: {
                        SnappingFragment.this.hideBars();
                        break;
                    }
                    case 4: {
                        if (SnappingFragment.this.animatingRetakePhoto) break;
                        SnappingFragment.this.showBars();
                    }
                }
                return false;
            }
        }
        this.rootView.setOnDragListener((View.OnDragListener)new DragListener());
    }

    private void attachPageEditors() {
        PagesEditor[] editors;
        for (PagesEditor editor : editors = new PagesEditor[]{this.pagesRearranger, this.deletePageEditor, this.rotatePageEditor}) {
            editor.attachViewPager(this.pager, this.adapter);
        }
    }

    protected void onCameraPageTransformation(View cameraView, float progress) {
        this.updateActionBarStatus(progress);
        this.adapter.getCameraFragment().setOpenProgress(progress);
        float scale = Math.max(0.7f, progress);
        cameraView.setScaleX(scale);
        cameraView.setScaleY(scale);
        int cameraWidth = cameraView.getWidth() - 2 * this.pager.getPageMargin();
        cameraView.setTranslationX((progress - 1.0f) * ((float)cameraWidth - (float)cameraWidth * scale) / 2.0f);
    }

    private void restoreState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        this.adapter.setDocumentDraft((DocumentDraft)savedInstanceState.getParcelable(DOCUMENT_DRAFT));
        this.updateTitle();
        this.docNameUpdatesEnabled = savedInstanceState.getBoolean(DOCUMENT_NAME_UPDATES);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(DOCUMENT_DRAFT, (Parcelable)this.adapter.getDocumentDraft());
        outState.putBoolean(DOCUMENT_NAME_UPDATES, this.docNameUpdatesEnabled);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 18: {
                this.handleEditActivityResult(resultCode, data);
                this.eventManager.fire((Object)new OnActivityResultEvent(requestCode, resultCode, data));
                break;
            }
            case 19: {
                this.handleRetakePhotoResult(resultCode, data);
            }
        }
    }

    private void handleEditActivityResult(int resultCode, Intent data) {
        if (resultCode != -1) {
            return;
        }
        Page resultPage = (Page)data.getParcelableExtra("page");
        Page page = this.adapter.getDocumentDraft().getPage(this.pager.getCurrentItem());
        if (resultPage != null && page != null) {
            page.setPolygon(resultPage.getPolygon());
        }
    }

    private void handleRetakePhotoResult(int resultCode, Intent data) {
        this.retakeCameraPlaceholder.setVisibility(8);
        this.showBars();
        if (resultCode != -1) {
            return;
        }
        final Page page = (Page)data.getParcelableExtra("RESULT_PAGE");
        final int position = data.getIntExtra("PAGE_POSITION", 0);
        this.pager.post(new Runnable(){

            @Override
            public void run() {
                SnappingFragment.this.adapter.deletePage(position);
                SnappingFragment.this.adapter.addPage(position, page);
                SnappingFragment.this.pager.setCurrentItem(position);
            }
        });
    }

    public void onPictureProcessingStatusChanged(@Observes(value=EventThread.UI) PictureProcessingStatusChangedEvent event) {
        if (event.isProcessing()) {
            this.pager.setEnabled(false);
        }
    }

    public void onPictureTaken(@Observes PictureTakenEvent event) {
        long pictureProcessingStart = SystemClock.elapsedRealtime();
        try {
            final Page page = this.pictureProcessor.processBytes(event.getImage(), event.getImageOrientation());
            String path = this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED_PREVIEW).getPath();
            Bitmap cached = (Bitmap)this.bitmapLruCache.get(path);
            final Bitmap optimized = cached != null ? cached : BitmapFactory.decodeFile((String)path);
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (!SnappingFragment.this.isAdded()) {
                        return;
                    }
                    SnappingFragment.this.addSnappedPage(page, optimized);
                    if (SnappingFragment.this.docNameUpdatesEnabled) {
                        SnappingFragment.this.adapter.getDocumentDraft().setDocumentName(SnappingFragment.this.smartNameBuilder.generateDocumentName());
                        SnappingFragment.this.updateTitle();
                    }
                }
            });
        }
        catch (IOException e) {
            DebugLog.logException(e);
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    SnappingFragment.this.resetSnappedPreview();
                    SnappingFragment.this.pager.setEnabled(true);
                    SnappingFragment.this.pager.setCurrentItem(SnappingFragment.this.adapter.getCount() - 1, false);
                    SnappingFragment.this.adapter.getCameraFragment().startCameraPreview();
                }
            });
        }
        long processingDuration = SystemClock.elapsedRealtime() - pictureProcessingStart;
        EasyTrackerWrapper.sendTiming("timing_snapping", processingDuration, "saving_snapped_page", Build.MODEL);
    }

    private void addSnappedPage(final Page page, Bitmap optimizedBitmap) {
        View camera = this.adapter.getCameraFragment().getView();
        int cameraWidth = camera.getWidth() - 2 * this.pager.getPageMargin();
        page.getParameters().putParcelable("PRESERVED_BITMAP", (Parcelable)optimizedBitmap);
        this.snappedPreview.setImageBitmap(optimizedBitmap);
        this.snappedPreview.setRotation((float)page.getRotationType().getDegrees());
        final float scale = this.calculateRotationScale(page.getRotationType());
        this.snappedPreview.setScaleX(scale);
        this.snappedPreview.setScaleY(scale);
        this.snappedPreview.animate().setListener((Animator.AnimatorListener)new ViewUtils.DefaultAnimationListener(){

            @Override
            public void onAnimationStart(Animator animator2) {
                SnappingFragment.this.snappedPreview.setVisibility(0);
                ViewUtils.saveViewTransformation((View)SnappingFragment.this.snappedPreview);
            }

            @Override
            public void onAnimationFinished(Animator animator2) {
                SnappingFragment.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        SnappingFragment.this.snappedPreview.animate().scaleX(scale).scaleY(scale).setListener((Animator.AnimatorListener)new ViewUtils.DefaultAnimationListener(){

                            @Override
                            public void onAnimationFinished(Animator animator2) {
                                if (!SnappingFragment.this.isAdded()) {
                                    return;
                                }
                                SnappingFragment.this.resetSnappedPreview();
                                SnappingFragment.this.insertPage(page);
                            }
                        }).start();
                    }
                });
            }
        }).scaleX(scale * 1.4f).scaleY(scale * 1.4f).start();
        camera.animate().scaleX(0.7f).scaleY(0.7f).translationX((float)cameraWidth * 1.7f / 2.0f).start();
    }

    private void resetSnappedPreview() {
        this.snappedPreview.setImageDrawable(null);
        this.snappedPreview.setVisibility(8);
        ViewUtils.restoreViewTransformation((View)this.snappedPreview);
    }

    private float calculateRotationScale(RotationType rotationType) {
        float actionBarHeight;
        float pageInnerMargin = this.getResources().getDimension(2131427334);
        float bottomBarHeight = actionBarHeight = this.getActivity() != null ? (float)this.getSupportActionBar().getHeight() : 0.0f;
        float dropdownTargetWidth = this.getResources().getDimension(2131427331);
        float availableWidth = (float)this.getView().getWidth() * 0.7f - 2.0f * dropdownTargetWidth;
        float availableHeight = (float)this.getView().getHeight() - 2.0f * pageInnerMargin - actionBarHeight - bottomBarHeight;
        if (this.snappedPreview.getDrawable() == null) {
            return 1.0f;
        }
        if (rotationType == RotationType.ROTATION_0 || rotationType == RotationType.ROTATION_180 || rotationType == RotationType.ROTATION_360) {
            return Math.min(availableWidth / (float)this.snappedPreview.getDrawable().getIntrinsicWidth(), availableHeight / (float)this.snappedPreview.getDrawable().getIntrinsicHeight());
        }
        return Math.min(availableWidth / (float)this.snappedPreview.getDrawable().getIntrinsicHeight(), availableHeight / (float)this.snappedPreview.getDrawable().getIntrinsicWidth());
    }

    private void insertPage(Page page) {
        this.pager.setEnabled(true);
        this.adapter.addPage(page);
        int pagesCount = this.adapter.getPagesCount();
        switch (pagesCount) {
            case 1: {
                AddNewPageTutorialFragment.newInstance().showOnce(this.getActivity(), this.preferences);
                break;
            }
            case 3: {
                RearrangementTutorialFragment.newInstance().showOnce(this.getActivity(), this.preferences);
            }
        }
        this.pager.setCurrentItem(this.adapter.getCount() - 2, false);
        this.adapter.getCameraFragment().startCameraPreview();
    }

    public void onPageLongPressed(@Observes OnPageLongPressedEvent event) {
        int pagePosition = this.adapter.getPagePosition(event.getDraggedPage());
        if (pagePosition != this.pager.getCurrentItem()) {
            return;
        }
        this.pagesRearranger.startRearrangement(event.getX(), event.getY(), event.getView(), event.getDraggedPage(), pagePosition, event.getDraggedFragment(), event.getPreservedBitmap());
    }

    public void onRetakePage(@Observes RetakePageEvent event) {
        if (event.shouldAnimate()) {
            this.retakePhotoWithAnimation(event.getPagePosition(), event.getDropX(), event.getDropY());
        } else {
            this.retakePhoto(event.getPagePosition());
        }
    }

    private void retakePhotoWithAnimation(final int pagePosition, float dropX, float dropY) {
        this.retakeCameraPlaceholder.setScaleX(0.0f);
        this.retakeCameraPlaceholder.setScaleY(0.0f);
        this.retakeCameraPlaceholder.setTranslationX(dropX - (float)this.pager.getWidth() / 2.0f);
        this.retakeCameraPlaceholder.setTranslationY(dropY - (float)this.pager.getHeight() / 2.0f);
        this.retakeCameraPlaceholder.animate().scaleX(1.0f).scaleY(1.0f).translationX(0.0f).translationY(0.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setDuration(300L).setListener((Animator.AnimatorListener)new ViewUtils.DefaultAnimationListener(){

            @Override
            public void onAnimationStart(Animator animation) {
                SnappingFragment.this.retakeCameraPlaceholder.setVisibility(0);
                SnappingFragment.this.animatingRetakePhoto = true;
            }

            @Override
            public void onAnimationFinished(Animator animation) {
                SnappingFragment.this.animatingRetakePhoto = false;
                SnappingFragment.this.retakePhoto(pagePosition);
            }
        }).start();
    }

    private void retakePhoto(int pagePosition) {
        if (this.getActivity() != null) {
            Intent intent = new Intent((Context)this.getActivity(), CameraActivity.class);
            intent.putExtra("PAGE_POSITION", pagePosition);
            intent.addFlags(65536);
            this.startActivityForResult(intent, 19);
        }
    }

    private void updateActionBarStatus(float progress) {
        if (this.pagesRearranger.isDragging() || this.animatingRetakePhoto || this.getFragmentManager().findFragmentByTag(BarcodeFragment.BARCODE_FRAGMENT_TAG) != null) {
            return;
        }
        this.updateActionBarBackground(progress);
        if (progress == 1.0f) {
            this.hideBars();
        } else {
            this.showBars();
        }
    }

    private void hideBars() {
        this.getSupportActionBar().hide();
        this.bottomBar.setEnabled(false);
        this.bottomBar.animate().translationY((float)this.bottomBar.getHeight()).start();
    }

    private void showBars() {
        this.getSupportActionBar().show();
        this.bottomBar.setEnabled(true);
        this.bottomBar.animate().translationY(0.0f).start();
    }

    private void updateActionBarBackground(float progress) {
        this.actionBarBackground.setAlpha((int)(255.0f * (1.0f - progress)));
        this.getSupportActionBar().setBackgroundDrawable(this.actionBarBackground);
        this.bottomBar.setAlpha(1.0f - progress);
        this.bottomBar.getBackground().setAlpha(255);
    }

    private ActionBar getSupportActionBar() {
        return this.getActionBarActivity().getActionBar();
    }

    private RoboFragmentActivity getActionBarActivity() {
        return (RoboFragmentActivity)this.getActivity();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.adapter.unregisterDataSetObserver(this.pagesObserver);
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu2, inflater);
        inflater.inflate(2131623940, menu2);
        DocumentDraft documentDraft = this.adapter.getDocumentDraft();
        if (documentDraft.isEmpty()) {
            menu2.findItem(2131296328).setVisible(false);
            menu2.findItem(2131296353).setVisible(false);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        DocumentDraft documentDraft = this.adapter.getDocumentDraft();
        if (item.getItemId() == 2131296353) {
            Bundle args = new Bundle();
            args.putString("CURRENT_NAME", documentDraft.getDocumentName());
            RenameDocumentFragment renameFragment = RenameDocumentFragment.newInstance(args);
            renameFragment.show(this.getFragmentManager(), RENAME_DOCUMENT_FRAGMENT_TAG);
            return true;
        }
        if (item.getItemId() == 2131296328) {
            if (this.editLock.isEditLocked()) {
                return true;
            }
            EasyTrackerWrapper.sendEvent("ui", "button_press", "save_document", 0L);
            this.eventManager.fire((Object)new CheckGenuinenessEvent(documentDraft));
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onDocumentRename(@Observes DocumentRenamedEvent event) {
        this.docNameUpdatesEnabled = false;
        this.adapter.getDocumentDraft().setDocumentName(event.getNewName());
        this.updateTitle();
        EasyTrackerWrapper.sendEvent("ui", "content", "document_renamed", 0L);
    }

    public void onDocumentSave(@Observes ProcessDocumentsEvent event) {
        this.docNameUpdatesEnabled = true;
        this.adapter.setDocumentDraft(new DocumentDraft(new Page[0]));
        this.adapter.notifyDataSetChanged();
    }

    public void saveDocument(@Observes SaveDocumentEvent event) {
        DocumentDraft documentDraft = event.getDraft();
        if (documentDraft.size() <= 1) {
            this.eventManager.fire((Object)new ProcessDocumentsEvent(documentDraft, true));
            EasyTrackerWrapper.sendEvent("ui", "button_press", "save_single_document", 0L);
        } else if (this.getFragmentManager().findFragmentByTag(SAVE_TYPE_FRAGMENT_TAG) == null) {
            SaveModeFragment.newInstance(documentDraft).show(this.getFragmentManager(), SAVE_TYPE_FRAGMENT_TAG);
        }
    }

    public void setCameraEnabled(boolean cameraEnabled) throws NullPointerException {
        CameraPreviewFragment cameraPreviewFragment = this.adapter.getCameraFragment();
        Fragment barcodeFragment = this.getFragmentManager().findFragmentByTag(BarcodeFragment.BARCODE_FRAGMENT_TAG);
        if (cameraPreviewFragment == null || barcodeFragment != null && barcodeFragment.isVisible()) {
            return;
        }
        cameraPreviewFragment.setCameraActive(cameraEnabled);
    }

    public void switchToPreview() {
        this.pager.setCurrentItem(this.adapter.getCount() - 1, true);
    }

    protected void updateTitle() {
        String title = this.adapter.getDocumentDraft().getDocumentName();
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.getSupportActionBar().setTitle((CharSequence)this.adapter.getDocumentDraft().getDocumentName());
        }
    }

    public boolean isCameraSelected() {
        if (this.adapter == null) {
            return false;
        }
        if (!this.currentPageIsCamera()) {
            return false;
        }
        CameraPreviewFragment cameraPreviewFragment = this.adapter.getCameraFragment();
        return cameraPreviewFragment != null && cameraPreviewFragment.isReady();
    }

    private boolean currentPageIsCamera() {
        return this.pager.getCurrentItem() == this.adapter.getCount() - 1;
    }

    private void onStartZooming(@Observes PrepareZoomEvent event) {
        this.pager.setEnabled(false);
    }

    private void onFinishZooming(@Observes ZoomingFinishedEvent event) {
        this.pager.setEnabled(true);
    }
}

