/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.util.billing;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.android.vending.billing.IInAppBillingService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.doo.snap.lib.billing.SecurityManager;
import net.doo.snap.lib.util.billing.IabException;
import net.doo.snap.lib.util.billing.IabResult;
import net.doo.snap.lib.util.billing.Inventory;
import net.doo.snap.lib.util.billing.Purchase;
import net.doo.snap.lib.util.billing.SkuDetails;
import net.doo.snap.lib.util.log.DebugLog;
import org.json.JSONException;

public class IabHelper {
    private static final int BILLING_API_VERSION = 3;
    public static final int BILLING_RESPONSE_RESULT_OK = 0;
    public static final int BILLING_RESPONSE_RESULT_USER_CANCELED = 1;
    public static final int BILLING_RESPONSE_RESULT_BILLING_UNAVAILABLE = 3;
    public static final int BILLING_RESPONSE_RESULT_ITEM_UNAVAILABLE = 4;
    public static final int BILLING_RESPONSE_RESULT_DEVELOPER_ERROR = 5;
    public static final int BILLING_RESPONSE_RESULT_ERROR = 6;
    public static final int BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED = 7;
    public static final int BILLING_RESPONSE_RESULT_ITEM_NOT_OWNED = 8;
    public static final int IABHELPER_ERROR_BASE = -1000;
    public static final int IABHELPER_REMOTE_EXCEPTION = -1001;
    public static final int IABHELPER_BAD_RESPONSE = -1002;
    public static final int IABHELPER_VERIFICATION_FAILED = -1003;
    public static final int IABHELPER_SEND_INTENT_FAILED = -1004;
    public static final int IABHELPER_USER_CANCELLED = -1005;
    public static final int IABHELPER_UNKNOWN_PURCHASE_RESPONSE = -1006;
    public static final int IABHELPER_MISSING_TOKEN = -1007;
    public static final int IABHELPER_UNKNOWN_ERROR = -1008;
    public static final int IABHELPER_SUBSCRIPTIONS_NOT_AVAILABLE = -1009;
    public static final int IABHELPER_INVALID_CONSUMPTION = -1010;
    public static final String RESPONSE_CODE = "RESPONSE_CODE";
    public static final String RESPONSE_GET_SKU_DETAILS_LIST = "DETAILS_LIST";
    public static final String RESPONSE_BUY_INTENT = "BUY_INTENT";
    public static final String RESPONSE_INAPP_PURCHASE_DATA = "INAPP_PURCHASE_DATA";
    public static final String RESPONSE_INAPP_SIGNATURE = "INAPP_DATA_SIGNATURE";
    public static final String RESPONSE_INAPP_ITEM_LIST = "INAPP_PURCHASE_ITEM_LIST";
    public static final String RESPONSE_INAPP_PURCHASE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
    public static final String RESPONSE_INAPP_SIGNATURE_LIST = "INAPP_DATA_SIGNATURE_LIST";
    public static final String INAPP_CONTINUATION_TOKEN = "INAPP_CONTINUATION_TOKEN";
    public static final String ITEM_TYPE_INAPP = "inapp";
    public static final String ITEM_TYPE_SUBS = "subs";
    public static final String GET_SKU_DETAILS_ITEM_LIST = "ITEM_ID_LIST";
    public static final String GET_SKU_DETAILS_ITEM_TYPE_LIST = "ITEM_TYPE_LIST";
    private final SecurityManager securityManager;
    private final SharedPreferences preferences;
    private AtomicBoolean setupDone = new AtomicBoolean(false);
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private boolean subscriptionsSupported = false;
    private AtomicBoolean asyncInProgress = new AtomicBoolean(false);
    private Context context;
    private IInAppBillingService service;
    private ServiceConnection serviceConn;
    private int requestCode;
    private String purchasingItemType;
    private OnIabPurchaseFinishedListener purchaseListener;

    public IabHelper(Context ctx) {
        this.context = ctx.getApplicationContext();
        this.securityManager = new SecurityManager();
        this.preferences = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        this.logDebug("IAB helper created.");
    }

    public void startSetup(final OnIabSetupFinishedListener listener) {
        this.ensureNotDisposed();
        if (this.setupDone.get()) {
            throw new IllegalStateException("IAB helper is already set up.");
        }
        this.logDebug("Starting in-app billing setup.");
        this.serviceConn = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName name) {
                IabHelper.this.logDebug("Billing service disconnected.");
                IabHelper.this.service = null;
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                if (IabHelper.this.disposed.get()) {
                    return;
                }
                IabHelper.this.logDebug("Billing service connected.");
                IabHelper.this.service = IInAppBillingService.Stub.asInterface(service);
                String packageName = IabHelper.this.context.getPackageName();
                try {
                    IabHelper.this.logDebug("Checking for in-app billing 3 support.");
                    int response = IabHelper.this.service.isBillingSupported(3, packageName, IabHelper.ITEM_TYPE_INAPP);
                    if (response != 0) {
                        if (listener != null) {
                            listener.onIabSetupFinished(new IabResult(response, "Error checking for billing v3 support."));
                        }
                        IabHelper.this.subscriptionsSupported = false;
                        return;
                    }
                    IabHelper.this.logDebug("In-app billing version 3 supported for " + packageName);
                    response = IabHelper.this.service.isBillingSupported(3, packageName, IabHelper.ITEM_TYPE_SUBS);
                    if (response == 0) {
                        IabHelper.this.logDebug("Subscriptions AVAILABLE.");
                        IabHelper.this.subscriptionsSupported = true;
                    } else {
                        IabHelper.this.logDebug("Subscriptions NOT AVAILABLE. Response: " + response);
                    }
                    IabHelper.this.setupDone.set(true);
                }
                catch (RemoteException e) {
                    if (listener != null) {
                        listener.onIabSetupFinished(new IabResult(-1001, "RemoteException while setting up in-app billing."));
                    }
                    DebugLog.logException(e);
                    return;
                }
                if (listener != null) {
                    listener.onIabSetupFinished(new IabResult(0, "Setup successful."));
                }
            }
        };
        Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
        serviceIntent.setPackage("com.android.vending");
        List resolveInfos = this.context.getPackageManager().queryIntentServices(serviceIntent, 0);
        if (resolveInfos != null && !resolveInfos.isEmpty()) {
            this.context.bindService(serviceIntent, this.serviceConn, 1);
        } else {
            this.serviceConn = null;
            if (listener != null) {
                listener.onIabSetupFinished(new IabResult(3, "Billing service unavailable on device."));
            }
        }
    }

    public void dispose() {
        this.logDebug("Disposing.");
        this.setupDone.set(false);
        if (this.serviceConn != null) {
            this.logDebug("Unbinding from service.");
            if (this.context != null) {
                this.context.unbindService(this.serviceConn);
            }
        }
        this.disposed.set(true);
        this.context = null;
        this.serviceConn = null;
        this.service = null;
        this.purchaseListener = null;
    }

    private void ensureNotDisposed() {
        if (this.disposed.get()) {
            throw new IllegalStateException("IabHelper was disposed of, so it cannot be used.");
        }
    }

    public boolean isSetupDone() {
        return this.setupDone.get();
    }

    public boolean subscriptionsSupported() {
        return this.subscriptionsSupported;
    }

    public void launchPurchaseFlow(Activity act, String sku, int requestCode, OnIabPurchaseFinishedListener listener) {
        String nonce = this.securityManager.generateNonce();
        this.preferences.edit().putString("NONCE_" + sku, nonce).commit();
        this.launchPurchaseFlow(act, sku, requestCode, listener, nonce);
    }

    public void launchPurchaseFlow(Activity act, String sku, int requestCode, OnIabPurchaseFinishedListener listener, String extraData) {
        this.launchPurchaseFlow(act, sku, ITEM_TYPE_INAPP, requestCode, listener, extraData);
    }

    public void launchSubscriptionPurchaseFlow(Activity act, String sku, int requestCode, OnIabPurchaseFinishedListener listener) {
        String nonce = this.securityManager.generateNonce();
        this.preferences.edit().putString("NONCE_" + sku, nonce).commit();
        this.launchSubscriptionPurchaseFlow(act, sku, requestCode, listener, nonce);
    }

    public void launchSubscriptionPurchaseFlow(Activity act, String sku, int requestCode, OnIabPurchaseFinishedListener listener, String extraData) {
        this.launchPurchaseFlow(act, sku, ITEM_TYPE_SUBS, requestCode, listener, extraData);
    }

    public void launchPurchaseFlow(Activity act, String sku, String itemType, int requestCode, OnIabPurchaseFinishedListener listener, String extraData) {
        this.ensureNotDisposed();
        this.ensureSetupDone();
        this.flagStartAsync();
        if (itemType.equals(ITEM_TYPE_SUBS) && !this.subscriptionsSupported) {
            this.flagEndAsync();
            this.deliverResult(listener, null, -1009, "Subscriptions are not available.");
            return;
        }
        try {
            this.logDebug("Constructing buy intent for " + sku + ", item type: " + itemType);
            Bundle buyIntentBundle = this.service.getBuyIntent(3, this.context.getPackageName(), sku, itemType, extraData);
            int response = this.getResponseCodeFromBundle(buyIntentBundle);
            if (response != 0) {
                this.logError("Unable to buy item, Error response: " + IabHelper.getResponseDesc(response));
                this.flagEndAsync();
                this.deliverResult(listener, null, response, "Unable to buy item");
                return;
            }
            PendingIntent pendingIntent = (PendingIntent)buyIntentBundle.getParcelable(RESPONSE_BUY_INTENT);
            this.logDebug("Launching buy intent for " + sku + ". Request code: " + requestCode);
            this.requestCode = requestCode;
            this.purchaseListener = listener;
            this.purchasingItemType = itemType;
            act.startIntentSenderForResult(pendingIntent.getIntentSender(), requestCode, new Intent(), 0, 0, 0);
        }
        catch (IntentSender.SendIntentException e) {
            this.logError("SendIntentException while launching purchase flow for sku " + sku);
            DebugLog.logException(e);
            this.flagEndAsync();
            this.deliverResult(listener, null, -1004, "Failed to send intent.");
        }
        catch (RemoteException e) {
            this.logError("RemoteException while launching purchase flow for sku " + sku);
            DebugLog.logException(e);
            this.flagEndAsync();
            this.deliverResult(listener, null, -1001, "Remote exception while starting purchase flow");
        }
    }

    public boolean handleActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != this.requestCode) {
            return false;
        }
        this.ensureNotDisposed();
        this.ensureSetupDone();
        this.flagEndAsync();
        if (data == null) {
            this.logError("Null data in IAB activity result.");
            this.deliverResult(this.purchaseListener, null, -1002, "Null data in IAB result");
            return true;
        }
        int responseCode = this.getResponseCodeFromIntent(data);
        String purchaseData = data.getStringExtra(RESPONSE_INAPP_PURCHASE_DATA);
        String dataSignature = data.getStringExtra(RESPONSE_INAPP_SIGNATURE);
        if (resultCode == -1 && responseCode == 0) {
            this.logDebug("Successful resultcode from purchase activity.");
            this.logDebug("Purchase data: " + purchaseData);
            this.logDebug("Data signature: " + dataSignature);
            this.logDebug("Extras: " + data.getExtras());
            this.logDebug("Expected item type: " + this.purchasingItemType);
            if (purchaseData == null || dataSignature == null) {
                this.logError("BUG: either purchaseData or dataSignature is null.");
                this.logDebug("Extras: " + data.getExtras().toString());
                this.deliverResult(this.purchaseListener, null, -1008, "IAB returned null purchaseData or dataSignature");
                return true;
            }
            Purchase purchase = null;
            String sku = null;
            try {
                purchase = new Purchase(this.purchasingItemType, purchaseData, dataSignature);
                sku = purchase.getSku();
                String storedPayload = this.preferences.getString("NONCE_" + sku, "");
                if (TextUtils.isEmpty((CharSequence)purchase.getDeveloperPayload()) || !storedPayload.equals(purchase.getDeveloperPayload())) {
                    this.logError("Purchase developer payload verification FAILED for sku " + sku);
                    this.deliverResult(this.purchaseListener, purchase, -1003, "Developer payload verification failed for sku " + sku);
                    return true;
                }
                this.preferences.edit().remove("NONCE_" + sku).commit();
                this.securityManager.verifySignature(purchaseData, dataSignature);
                this.logDebug("Purchase signature successfully verified.");
            }
            catch (JSONException e) {
                this.logError("Failed to parse purchase data.");
                DebugLog.logException(e);
                this.deliverResult(this.purchaseListener, null, -1002, "Failed to parse purchase data.");
                return true;
            }
            catch (SecurityManager.VerificationFailedException e) {
                this.logError("Purchase signature verification FAILED for sku " + sku);
                DebugLog.logException(e);
                this.deliverResult(this.purchaseListener, null, -1003, "Signature verification failed for sku " + sku);
                return true;
            }
            this.deliverResult(this.purchaseListener, purchase, 0, "Success");
        } else if (resultCode == -1) {
            this.logDebug("Result code was OK but in-app billing response was not OK: " + IabHelper.getResponseDesc(responseCode));
            this.deliverResult(this.purchaseListener, null, responseCode, "Problem purchashing item.");
        } else if (resultCode == 0) {
            this.logDebug("Purchase canceled - Response: " + IabHelper.getResponseDesc(responseCode));
            this.deliverResult(this.purchaseListener, null, -1005, "User canceled.");
        } else {
            this.logError("Purchase failed. Result code: " + Integer.toString(resultCode) + ". Response: " + IabHelper.getResponseDesc(responseCode));
            this.deliverResult(this.purchaseListener, null, -1006, "Unknown purchase response.");
        }
        return true;
    }

    private void deliverResult(OnIabPurchaseFinishedListener listener, Purchase purchase, int resultCode, String resultMessage) {
        if (listener != null) {
            listener.onIabPurchaseFinished(new IabResult(resultCode, resultMessage), purchase);
        }
    }

    public Inventory queryInventory(boolean querySkuDetails, List<String> moreSkus) throws IabException {
        return this.queryInventory(querySkuDetails, moreSkus, null);
    }

    public Inventory queryInventory(boolean querySkuDetails, List<String> moreItemSkus, List<String> moreSubsSkus) throws IabException {
        this.ensureNotDisposed();
        this.ensureSetupDone();
        try {
            Inventory inv = new Inventory();
            int result = this.queryPurchases(inv, ITEM_TYPE_INAPP);
            if (result != 0) {
                throw new IabException(result, "Error refreshing inventory (querying owned items).");
            }
            if (querySkuDetails && (result = this.querySkuDetails(ITEM_TYPE_INAPP, inv, moreItemSkus)) != 0) {
                throw new IabException(result, "Error refreshing inventory (querying prices of items).");
            }
            if (this.subscriptionsSupported) {
                result = this.queryPurchases(inv, ITEM_TYPE_SUBS);
                if (result != 0) {
                    throw new IabException(result, "Error refreshing inventory (querying owned subscriptions).");
                }
                if (querySkuDetails && (result = this.querySkuDetails(ITEM_TYPE_SUBS, inv, moreItemSkus)) != 0) {
                    throw new IabException(result, "Error refreshing inventory (querying prices of subscriptions).");
                }
            }
            return inv;
        }
        catch (RemoteException e) {
            throw new IabException(-1001, "Remote exception while refreshing inventory.", (Exception)((Object)e));
        }
        catch (JSONException e) {
            throw new IabException(-1002, "Error parsing JSON response while refreshing inventory.", (Exception)((Object)e));
        }
    }

    public void consume(Purchase itemInfo) throws IabException {
        this.ensureNotDisposed();
        this.ensureSetupDone();
        if (!itemInfo.getItemType().equals(ITEM_TYPE_INAPP)) {
            throw new IabException(-1010, "Items of type '" + itemInfo.getItemType() + "' can't be consumed.");
        }
        try {
            String token = itemInfo.getToken();
            String sku = itemInfo.getSku();
            if (TextUtils.isEmpty((CharSequence)token)) {
                this.logError("Can't consume " + sku + ". No token.");
                throw new IabException(-1007, "PurchaseInfo is missing token for sku: " + sku + " " + itemInfo);
            }
            this.logDebug("Consuming sku: " + sku + ", token: " + token);
            int response = this.service.consumePurchase(3, this.context.getPackageName(), token);
            if (response != 0) {
                this.logDebug("Error consuming consuming sku " + sku + ". " + IabHelper.getResponseDesc(response));
                throw new IabException(response, "Error consuming sku " + sku);
            }
            this.logDebug("Successfully consumed sku: " + sku);
        }
        catch (RemoteException e) {
            throw new IabException(-1001, "Remote exception while consuming. PurchaseInfo: " + itemInfo, (Exception)((Object)e));
        }
    }

    public static String getResponseDesc(int code) {
        String[] iabResponses = new String[]{"0:OK", "1:User Canceled", "2:Unknown", "3:Billing Unavailable", "4:Item unavailable", "5:Developer Error", "6:Error", "7:Item Already Owned", "8:Item not owned"};
        String[] iabHelperResponses = new String[]{"0:OK", "-1001:Remote exception during initialization", "-1002:Bad response received", "-1003:Purchase signature verification failed", "-1004:Send intent failed", "-1005:User cancelled", "-1006:Unknown purchase response", "-1007:Missing token", "-1008:Unknown error", "-1009:Subscriptions not available", "-1010:Invalid consumption attempt"};
        if (code <= -1000) {
            int index = -1000 - code;
            if (index >= 0 && index < iabHelperResponses.length) {
                return iabHelperResponses[index];
            }
            return String.valueOf(code) + ":Unknown IAB Helper Error";
        }
        if (code < 0 || code >= iabResponses.length) {
            return String.valueOf(code) + ":Unknown";
        }
        return iabResponses[code];
    }

    private void ensureSetupDone() {
        if (this.setupDone.compareAndSet(false, false)) {
            this.logError("Illegal state for operation: IAB helper is not set up.");
            throw new IllegalStateException("IAB helper is not set up. Can't perform operation.");
        }
    }

    private int getResponseCodeFromBundle(Bundle bundle) {
        Object object = bundle.get(RESPONSE_CODE);
        if (object == null) {
            this.logDebug("Bundle with null response code, assuming OK (known issue)");
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        this.logError("Unexpected type for bundle response code.");
        this.logError(object.getClass().getName());
        throw new RuntimeException("Unexpected type for bundle response code: " + object.getClass().getName());
    }

    private int getResponseCodeFromIntent(Intent intent) {
        return this.getResponseCodeFromBundle(intent.getExtras());
    }

    private void flagStartAsync() {
        if (this.asyncInProgress.getAndSet(true)) {
            throw new IllegalStateException("Can't start async operation because another async operation is in progress.");
        }
        this.logDebug("Starting async operation");
    }

    private void flagEndAsync() {
        this.logDebug("Ending async operation");
        this.asyncInProgress.set(false);
    }

    private int queryPurchases(Inventory inv, String itemType) throws JSONException, RemoteException {
        this.logDebug("Querying owned items, item type: " + itemType);
        this.logDebug("Package name: " + this.context.getPackageName());
        boolean verificationFailed = false;
        String continueToken = null;
        do {
            this.logDebug("Calling getPurchases with continuation token: " + continueToken);
            Bundle ownedItems = this.service.getPurchases(3, this.context.getPackageName(), itemType, continueToken);
            int response = this.getResponseCodeFromBundle(ownedItems);
            this.logDebug("Owned items response: " + String.valueOf(response));
            if (response != 0) {
                this.logDebug("getPurchases() failed: " + IabHelper.getResponseDesc(response));
                return response;
            }
            if (!(ownedItems.containsKey(RESPONSE_INAPP_ITEM_LIST) && ownedItems.containsKey(RESPONSE_INAPP_PURCHASE_DATA_LIST) && ownedItems.containsKey(RESPONSE_INAPP_SIGNATURE_LIST))) {
                this.logError("Bundle returned from getPurchases() doesn't contain required fields.");
                return -1002;
            }
            ArrayList ownedSkus = ownedItems.getStringArrayList(RESPONSE_INAPP_ITEM_LIST);
            ArrayList purchaseDataList = ownedItems.getStringArrayList(RESPONSE_INAPP_PURCHASE_DATA_LIST);
            ArrayList signatureList = ownedItems.getStringArrayList(RESPONSE_INAPP_SIGNATURE_LIST);
            for (int i = 0; i < purchaseDataList.size(); ++i) {
                String purchaseData = (String)purchaseDataList.get(i);
                String signature = (String)signatureList.get(i);
                String sku = (String)ownedSkus.get(i);
                try {
                    this.securityManager.verifySignature(purchaseData, signature);
                    this.logDebug("Sku is owned: " + sku);
                    Purchase purchase = new Purchase(itemType, purchaseData, signature);
                    if (TextUtils.isEmpty((CharSequence)purchase.getToken())) {
                        this.logWarn("BUG: empty/null token!");
                        this.logDebug("Purchase data: " + purchaseData);
                    }
                    inv.addPurchase(purchase);
                    continue;
                }
                catch (SecurityManager.VerificationFailedException e) {
                    DebugLog.logException(e);
                    this.logWarn("Purchase signature verification **FAILED**. Not adding item.");
                    this.logDebug("   Purchase data: " + purchaseData);
                    this.logDebug("   Signature: " + signature);
                    verificationFailed = true;
                }
            }
            continueToken = ownedItems.getString(INAPP_CONTINUATION_TOKEN);
            this.logDebug("Continuation token: " + continueToken);
        } while (!TextUtils.isEmpty((CharSequence)continueToken));
        return verificationFailed ? -1003 : 0;
    }

    private int querySkuDetails(String itemType, Inventory inv, List<String> moreSkus) throws RemoteException, JSONException {
        this.logDebug("Querying SKU details.");
        ArrayList<String> skuList = new ArrayList<String>();
        skuList.addAll(inv.getAllOwnedSkus(itemType));
        if (moreSkus != null) {
            for (String sku : moreSkus) {
                if (skuList.contains(sku)) continue;
                skuList.add(sku);
            }
        }
        if (skuList.size() == 0) {
            this.logDebug("queryPrices: nothing to do because there are no SKUs.");
            return 0;
        }
        Bundle querySkus = new Bundle();
        querySkus.putStringArrayList(GET_SKU_DETAILS_ITEM_LIST, skuList);
        Bundle skuDetails = this.service.getSkuDetails(3, this.context.getPackageName(), itemType, querySkus);
        if (!skuDetails.containsKey(RESPONSE_GET_SKU_DETAILS_LIST)) {
            int response = this.getResponseCodeFromBundle(skuDetails);
            if (response != 0) {
                this.logDebug("getSkuDetails() failed: " + IabHelper.getResponseDesc(response));
                return response;
            }
            this.logError("getSkuDetails() returned a bundle with neither an error nor a detail list.");
            return -1002;
        }
        ArrayList responseList = skuDetails.getStringArrayList(RESPONSE_GET_SKU_DETAILS_LIST);
        for (String thisResponse : responseList) {
            SkuDetails d = new SkuDetails(itemType, thisResponse);
            this.logDebug("Got sku details: " + d);
            inv.addSkuDetails(d);
        }
        return 0;
    }

    private void logDebug(String msg) {
        DebugLog.d(msg);
    }

    private void logError(String msg) {
        DebugLog.e("In-app billing error: " + msg);
    }

    private void logWarn(String msg) {
        DebugLog.w("In-app billing warning: " + msg);
    }

    public static interface OnIabPurchaseFinishedListener {
        public void onIabPurchaseFinished(IabResult var1, Purchase var2);
    }

    public static interface OnIabSetupFinishedListener {
        public void onIabSetupFinished(IabResult var1);
    }
}

