/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.inject.Inject;
import java.io.IOException;
import net.doo.snap.lib.analytics.ActivityAnalytics;
import net.doo.snap.lib.analytics.EasyTrackerWrapper;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PictureProcessor;
import net.doo.snap.lib.snap.camera.CameraPreviewFragment;
import net.doo.snap.lib.snap.event.PictureTakenEvent;
import net.doo.snap.lib.util.log.DebugLog;
import net.doo.snap.lib.util.ui.ViewUtils;
import roboguice.activity.RoboFragmentActivity;
import roboguice.event.Observes;

public class CameraActivity
extends RoboFragmentActivity {
    public static final String PAGE_POSITION = "PAGE_POSITION";
    public static final String RESULT_PAGE = "RESULT_PAGE";
    @Inject
    private PictureProcessor pictureProcessor;
    @Inject
    private ActivityAnalytics activityAnalytics;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903046);
        final CameraPreviewFragment cameraPreviewFragment = (CameraPreviewFragment)this.getSupportFragmentManager().findFragmentById(2131296298);
        ViewUtils.postOnPreDraw(this.findViewById(2131296298), new Runnable(){

            @Override
            public void run() {
                cameraPreviewFragment.setPreviewMode(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPictureTaken(@Observes PictureTakenEvent event) {
        long pictureProcessingStart = SystemClock.elapsedRealtime();
        Page page = null;
        try {
            page = this.pictureProcessor.processBytes(event.getImage(), event.getImageOrientation());
            this.deliverResult(page);
        }
        catch (IOException e) {
            try {
                DebugLog.logException(e);
                this.deliverResult(page);
            }
            catch (Throwable throwable) {
                this.deliverResult(page);
                throw throwable;
            }
        }
        long processingDuration = SystemClock.elapsedRealtime() - pictureProcessingStart;
        EasyTrackerWrapper.sendTiming("timing_snapping", processingDuration, "saving_snapped_page", Build.MODEL);
    }

    private void deliverResult(final Page page) {
        this.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (page != null) {
                        Intent intent = new Intent();
                        intent.putExtra(CameraActivity.RESULT_PAGE, (Parcelable)page);
                        intent.putExtra(CameraActivity.PAGE_POSITION, CameraActivity.this.getIntent().getIntExtra(CameraActivity.PAGE_POSITION, 0));
                        CameraActivity.this.setResult(-1, intent);
                    }
                }
                finally {
                    CameraActivity.this.finish();
                }
            }
        });
    }
}

