package net.doo.snap.lib.snap.event;

import net.doo.snap.lib.persistence.OptimizationType;
import net.doo.snap.lib.persistence.Page;

/**
 * Fired when {@link net.doo.snap.lib.persistence.OptimizationType} of {@link net.doo.snap.lib.persistence.Page}
 * has changed
 */
public class PageOptimizationTypeChangedEvent {

    private Page page;
    private OptimizationType optimizationType;

    public PageOptimizationTypeChangedEvent(Page page, OptimizationType optimizationType) {
        this.page = page;
        this.optimizationType = optimizationType;
    }

    /**
     * @return {@link net.doo.snap.lib.persistence.Page} which was changed
     */
    public Page getPage() {
        return page;
    }

    /**
     * @return {@link net.doo.snap.lib.persistence.OptimizationType} which should be used by {@link net.doo.snap.lib.persistence.Page}
     */
    public OptimizationType getOptimizationType() {
        return optimizationType;
    }
}
