package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import com.google.zxing.client.result.EmailAddressParsedResult;
import net.doo.snap.lib.R;

/**
 * Handles email addresses.
 */
public final class EmailAddressResultHandler extends ResultHandler {
    private static final int[] buttons = {
            R.string.button_email,
            R.string.button_add_contact
    };
    private static final int SEND_EMAIL = 0;
    private static final int ADD_TO_CONTACTS = 1;

    public EmailAddressResultHandler(Activity activity, EmailAddressParsedResult result) {
        super(activity, result);
    }

    @Override
    public EmailAddressParsedResult getResult() {
        return (EmailAddressParsedResult) super.getResult();
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        EmailAddressParsedResult emailResult = getResult();
        switch (index) {
            case SEND_EMAIL:
                sendEmailFromUri(emailResult.getMailtoURI(),
                        emailResult.getEmailAddress(),
                        emailResult.getSubject(),
                        emailResult.getBody());
                break;
            case ADD_TO_CONTACTS:
                String[] addresses = new String[] {
                        emailResult.getEmailAddress()
                };
                addEmailOnlyContact(addresses, null);
                break;
        }
    }

    @Override
    public String getDisplayTitle() {
        return getResult().getEmailAddress();
    }

    @Override
    public String getDisplaySubtitle() {
        return null;
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    public int getDisplayIconRes() {
        return R.drawable.ui_qr_ico_mail;
    }
}
