/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera.barcode;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class LocaleManager {
    private static final String DEFAULT_TLD = "com";
    private static final String DEFAULT_COUNTRY = "US";
    private static final Map<String, String> GOOGLE_COUNTRY_TLD = new HashMap<String, String>();
    private static final Map<String, String> GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD;
    private static final Map<String, String> GOOGLE_BOOK_SEARCH_COUNTRY_TLD;

    private LocaleManager() {
    }

    public static String getCountryTLD() {
        return LocaleManager.doGetTLD(GOOGLE_COUNTRY_TLD);
    }

    public static String getProductSearchCountryTLD() {
        return LocaleManager.doGetTLD(GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD);
    }

    public static String getBookSearchCountryTLD() {
        return LocaleManager.doGetTLD(GOOGLE_BOOK_SEARCH_COUNTRY_TLD);
    }

    private static String getSystemCountry() {
        Locale locale = Locale.getDefault();
        return locale == null ? DEFAULT_COUNTRY : locale.getCountry();
    }

    private static String doGetTLD(Map<String, String> map) {
        String tld = map.get(LocaleManager.getSystemCountry());
        return tld == null ? DEFAULT_TLD : tld;
    }

    static {
        GOOGLE_COUNTRY_TLD.put("AR", "com.ar");
        GOOGLE_COUNTRY_TLD.put("AU", "com.au");
        GOOGLE_COUNTRY_TLD.put("BR", "com.br");
        GOOGLE_COUNTRY_TLD.put("BG", "bg");
        GOOGLE_COUNTRY_TLD.put(Locale.CANADA.getCountry(), "ca");
        GOOGLE_COUNTRY_TLD.put(Locale.CHINA.getCountry(), "cn");
        GOOGLE_COUNTRY_TLD.put("CZ", "cz");
        GOOGLE_COUNTRY_TLD.put("DK", "dk");
        GOOGLE_COUNTRY_TLD.put("FI", "fi");
        GOOGLE_COUNTRY_TLD.put(Locale.FRANCE.getCountry(), "fr");
        GOOGLE_COUNTRY_TLD.put(Locale.GERMANY.getCountry(), "de");
        GOOGLE_COUNTRY_TLD.put("GR", "gr");
        GOOGLE_COUNTRY_TLD.put("HU", "hu");
        GOOGLE_COUNTRY_TLD.put("ID", "co.id");
        GOOGLE_COUNTRY_TLD.put("IL", "co.il");
        GOOGLE_COUNTRY_TLD.put(Locale.ITALY.getCountry(), "it");
        GOOGLE_COUNTRY_TLD.put(Locale.JAPAN.getCountry(), "co.jp");
        GOOGLE_COUNTRY_TLD.put(Locale.KOREA.getCountry(), "co.kr");
        GOOGLE_COUNTRY_TLD.put("NL", "nl");
        GOOGLE_COUNTRY_TLD.put("PL", "pl");
        GOOGLE_COUNTRY_TLD.put("PT", "pt");
        GOOGLE_COUNTRY_TLD.put("RO", "ro");
        GOOGLE_COUNTRY_TLD.put("RU", "ru");
        GOOGLE_COUNTRY_TLD.put("SK", "sk");
        GOOGLE_COUNTRY_TLD.put("SI", "si");
        GOOGLE_COUNTRY_TLD.put("ES", "es");
        GOOGLE_COUNTRY_TLD.put("SE", "se");
        GOOGLE_COUNTRY_TLD.put("CH", "ch");
        GOOGLE_COUNTRY_TLD.put(Locale.TAIWAN.getCountry(), "tw");
        GOOGLE_COUNTRY_TLD.put("TR", "com.tr");
        GOOGLE_COUNTRY_TLD.put(Locale.UK.getCountry(), "co.uk");
        GOOGLE_COUNTRY_TLD.put(Locale.US.getCountry(), DEFAULT_TLD);
        GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD = new HashMap<String, String>();
        GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD.put("AU", "com.au");
        GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD.put(Locale.FRANCE.getCountry(), "fr");
        GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD.put(Locale.GERMANY.getCountry(), "de");
        GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD.put(Locale.ITALY.getCountry(), "it");
        GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD.put(Locale.JAPAN.getCountry(), "co.jp");
        GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD.put("NL", "nl");
        GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD.put("ES", "es");
        GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD.put("CH", "ch");
        GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD.put(Locale.UK.getCountry(), "co.uk");
        GOOGLE_PRODUCT_SEARCH_COUNTRY_TLD.put(Locale.US.getCountry(), DEFAULT_TLD);
        GOOGLE_BOOK_SEARCH_COUNTRY_TLD = GOOGLE_COUNTRY_TLD;
    }
}

