/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui;

import android.app.ActionBar;
import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.inject.Inject;
import com.google.zxing.Result;
import com.google.zxing.client.result.GeoParsedResult;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;
import net.doo.snap.lib.analytics.EasyTrackerWrapper;
import net.doo.snap.lib.snap.camera.barcode.BarcodeDetector;
import net.doo.snap.lib.snap.camera.barcode.result.ResultHandler;
import net.doo.snap.lib.snap.camera.barcode.result.ResultHandlerFactory;
import net.doo.snap.lib.ui.SnappingFragment;
import net.doo.snap.lib.ui.widget.text.CustomTypefaceTextView;
import roboguice.fragment.RoboFragment;

public class BarcodeFragment
extends RoboFragment {
    public static String BARCODE_FRAGMENT_TAG = "BARCODE_FRAGMENT";
    private static final String ACTION_BAR_TITLE = "ACTION_BAR_TITLE";
    private static final int DEFAULT_MAP_ZOOM = 15;
    @Inject
    private BarcodeDetector barcodeDetector;
    @Inject
    private Context context;
    private ImageView codeTypeImage;
    private Result lastCodeResult;
    private TextView title;
    private TextView subTitle;
    private TextView contentText;
    private LinearLayout buttonsContainer;
    private ResultHandler barcodeHandler;
    private WebView webContainer;
    private View contentContainer;
    private GoogleMap map;
    private MapView mapView;
    private Drawable actionBarBg;
    private String externalTitle;
    private ParsedResultType resultType;
    private View buttonsScrollContainer;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
        this.lastCodeResult = this.barcodeDetector.getLastResult();
        if (this.lastCodeResult == null) {
            this.getActivity().getSupportFragmentManager().popBackStack();
            return;
        }
        this.barcodeHandler = ResultHandlerFactory.makeResultHandler((Activity)this.getActivity(), this.lastCodeResult);
        ParsedResult result = this.barcodeHandler.getResult();
        if (result == null || result.getType() == null) {
            this.getActivity().getSupportFragmentManager().popBackStack();
            return;
        }
        this.resultType = result.getType();
        if (savedInstanceState != null) {
            this.externalTitle = savedInstanceState.getString(ACTION_BAR_TITLE, "");
        } else {
            ActionBar actionBar = this.getActivity().getActionBar();
            if (!TextUtils.isEmpty((CharSequence)actionBar.getTitle())) {
                this.externalTitle = actionBar.getTitle().toString();
            }
        }
        this.actionBarBg = this.getResources().getDrawable(2131230743);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(2130903044, container, false);
        this.codeTypeImage = (ImageView)rootView.findViewById(2131296288);
        this.title = (TextView)rootView.findViewById(2131296289);
        this.subTitle = (TextView)rootView.findViewById(2131296290);
        this.contentText = (TextView)rootView.findViewById(2131296291);
        this.contentContainer = rootView.findViewById(2131296286);
        this.buttonsContainer = (LinearLayout)rootView.findViewById(2131296287);
        this.buttonsScrollContainer = rootView.findViewById(2131296294);
        if (this.buttonsScrollContainer == null) {
            this.buttonsScrollContainer = this.buttonsContainer;
        }
        this.webContainer = (WebView)rootView.findViewById(2131296292);
        this.mapView = (MapView)rootView.findViewById(2131296293);
        MapsInitializer.initialize((Context)this.getActivity());
        this.initContent(savedInstanceState);
        this.initActionButton();
        EasyTrackerWrapper.sendEvent("ui", "qr", this.resultType.toString(), 0L);
        return rootView;
    }

    public void onResume() {
        super.onResume();
        ActionBar actionBar = this.getActivity().getActionBar();
        actionBar.setBackgroundDrawable(this.actionBarBg);
        this.actionBarBg.setAlpha(255);
        actionBar.setTitle((CharSequence)this.context.getString(2131165277));
        actionBar.setHomeButtonEnabled(true);
        actionBar.setDisplayHomeAsUpEnabled(true);
        actionBar.show();
        if (this.resultType == ParsedResultType.GEO) {
            this.mapView.onResume();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putString(ACTION_BAR_TITLE, this.externalTitle);
        super.onSaveInstanceState(outState);
    }

    public void onPause() {
        super.onPause();
        if (this.resultType == ParsedResultType.GEO) {
            this.mapView.onPause();
        }
    }

    public void onStop() {
        ActionBar actionBar = this.getActivity().getActionBar();
        this.actionBarBg.setAlpha(0);
        actionBar.setBackgroundDrawable(this.actionBarBg);
        actionBar.setHomeButtonEnabled(true);
        actionBar.setDisplayHomeAsUpEnabled(true);
        actionBar.setTitle((CharSequence)this.externalTitle);
        actionBar.hide();
        this.barcodeDetector.resetBarcodeDetectionTimer();
        ((SnappingFragment)this.getFragmentManager().findFragmentById(2131296339)).setCameraEnabled(true);
        super.onStop();
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (this.resultType == ParsedResultType.GEO) {
            this.mapView.onLowMemory();
        }
    }

    public void onDestroy() {
        if (this.resultType == ParsedResultType.GEO) {
            this.mapView.onDestroy();
        }
        super.onDestroy();
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        menu2.clear();
        inflater.inflate(2131623936, menu2);
        super.onCreateOptionsMenu(menu2, inflater);
    }

    private void initContent(Bundle savedInstanceState) {
        String displayTitle = this.barcodeHandler.getDisplayTitle();
        this.title.setVisibility(TextUtils.isEmpty((CharSequence)displayTitle) ? 8 : 0);
        this.title.setText((CharSequence)displayTitle);
        String displaySubtitle = this.barcodeHandler.getDisplaySubtitle();
        this.subTitle.setVisibility(TextUtils.isEmpty((CharSequence)displaySubtitle) ? 8 : 0);
        this.subTitle.setText((CharSequence)displaySubtitle);
        String displayText = this.barcodeHandler.getDisplayText();
        this.contentText.setVisibility(TextUtils.isEmpty((CharSequence)displayText) ? 8 : 0);
        this.contentText.setText((CharSequence)displayText);
        this.codeTypeImage.setImageResource(this.barcodeHandler.getDisplayIconRes());
        switch (this.resultType) {
            case ADDRESSBOOK: 
            case EMAIL_ADDRESS: 
            case PRODUCT: 
            case WIFI: 
            case TEL: 
            case SMS: 
            case CALENDAR: 
            case ISBN: {
                break;
            }
            case URI: {
                this.contentContainer.setVisibility(8);
                this.codeTypeImage.setVisibility(8);
                this.webContainer.setVisibility(0);
                this.buttonsScrollContainer.setBackgroundColor(this.getResources().getColor(2131230766));
                this.webContainer.getSettings().setJavaScriptEnabled(true);
                this.webContainer.setWebViewClient(new WebViewClient());
                this.webContainer.setWebChromeClient(new WebChromeClient(){

                    public void onProgressChanged(WebView view, int newProgress) {
                        super.onProgressChanged(view, newProgress);
                        FragmentActivity activity = BarcodeFragment.this.getActivity();
                        if (activity == null) {
                            return;
                        }
                        if (newProgress >= 100) {
                            activity.setProgressBarVisibility(false);
                        } else {
                            activity.setProgress(100 * newProgress);
                            activity.setProgressBarVisibility(true);
                        }
                    }
                });
                this.webContainer.loadUrl(this.barcodeHandler.getDisplayTitle());
                break;
            }
            case GEO: {
                if (GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.context) != 0) break;
                this.mapView.setVisibility(0);
                this.contentContainer.setVisibility(8);
                this.codeTypeImage.setVisibility(8);
                this.buttonsScrollContainer.setBackgroundColor(this.getResources().getColor(2131230766));
                this.mapView.onCreate(savedInstanceState);
                this.map = this.mapView.getMap();
                if (this.map == null) {
                    return;
                }
                GeoParsedResult geoResult = (GeoParsedResult)this.barcodeHandler.getResult();
                LatLng position = new LatLng(geoResult.getLatitude(), geoResult.getLongitude());
                this.map.addMarker(new MarkerOptions().position(position));
                this.map.moveCamera(CameraUpdateFactory.newLatLngZoom((LatLng)position, (float)15.0f));
                break;
            }
            default: {
                this.codeTypeImage.setVisibility(8);
                this.contentText.setGravity(3);
                this.contentText.setTextSize(0, (float)this.getResources().getDimensionPixelSize(2131427344));
            }
        }
    }

    private void initActionButton() {
        this.buttonsContainer.setVisibility(this.barcodeHandler.getButtonCount() > 0 ? 0 : 8);
        int index = 0;
        while (index < this.barcodeHandler.getButtonCount()) {
            CustomTypefaceTextView button = (CustomTypefaceTextView)this.getLayoutInflater(null).inflate(2130903043, null);
            button.setText(this.barcodeHandler.getButtonText(index));
            final int finalIndex = index++;
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BarcodeFragment.this.barcodeHandler.handleButtonPress(finalIndex);
                }
            });
            this.buttonsContainer.addView((View)button);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 2131296349) {
            ClipboardManager clipboard = (ClipboardManager)this.getActivity().getSystemService("clipboard");
            ClipData clip = ClipData.newPlainText((CharSequence)"", (CharSequence)this.barcodeHandler.getResult().getDisplayResult());
            clipboard.setPrimaryClip(clip);
            Toast.makeText((Context)this.getActivity(), (CharSequence)this.getString(2131165284), (int)0).show();
            return true;
        }
        if (item.getItemId() == 2131296350) {
            Intent sharingIntent = new Intent("android.intent.action.SEND");
            sharingIntent.setType("text/plain");
            sharingIntent.putExtra("android.intent.extra.TEXT", this.barcodeHandler.getResult().getDisplayResult());
            this.startActivity(Intent.createChooser((Intent)sharingIntent, (CharSequence)this.getString(2131165282)));
            return true;
        }
        if (item.getItemId() == 16908332) {
            this.getActivity().onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onBackPressed() {
        boolean canGoBack;
        boolean bl = canGoBack = this.resultType == ParsedResultType.URI && this.webContainer.canGoBack();
        if (canGoBack) {
            this.webContainer.goBack();
        }
        return canGoBack;
    }
}

