package net.doo.snap.lib.ui.themes;

import net.doo.snap.lib.R;

/**
 * Application themes
 */
public enum Theme {
    SCANBOT(0, R.string.scanbot_theme_name),
    SALMON(1, R.string.salmon_theme_name);

    private int id;
    private int nameResId;

    Theme(int id, int nameResId) {
        this.id = id;
        this.nameResId = nameResId;
    }

    /**
     * @return {@link Theme}s database id
     */
    public int getId() {
        return id;
    }

    /**
     * @return name string res id
     */
    public int getNameResId() {
        return nameResId;
    }

    /**
     * @param id
     * @return {@link Theme} by associated database id
     */
    public static Theme getThemeById(int id) {
        switch (id) {
            case 0:
                return SCANBOT;
            case 1:
                return SALMON;
            default:
                return SCANBOT;
        }
    }
}
