package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.widget.Toast;

import com.google.zxing.client.result.WifiParsedResult;

import net.doo.snap.lib.R;
import net.doo.snap.lib.snap.camera.barcode.wifi.WifiConfigManager;
import net.doo.snap.lib.util.ThemesHelper;
import net.doo.snap.lib.util.log.DebugLog;

/**
 * Handles wifi access information.
 */
public final class WifiResultHandler extends ResultHandler {
    private static final int CONNECT_TO_WIFI = 0;
    private final Activity parent;

    public WifiResultHandler(Activity activity, WifiParsedResult result) {
        super(activity, result);
        parent = activity;
    }

    @Override
    public WifiParsedResult getResult() {
        return (WifiParsedResult) super.getResult();
    }

    @Override
    public int getButtonCount() {
        // We just need one button, and that is to configure the wireless.  This could change in the future.
        Object wifiManager = getActivity().getApplicationContext().getSystemService(Context.WIFI_SERVICE);
        if (wifiManager == null) {
            DebugLog.w("No WifiManager available from device");
            return 0;
        }
        return 1;
    }

    @Override
    public int getButtonText(int index) {
        return R.string.button_wifi;
    }

    @Override
    public void handleButtonPress(int index) {
        if (index == CONNECT_TO_WIFI) {
            final Activity activity = getActivity();
            WifiManager wifiManager = (WifiManager) activity.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    Toast.makeText(activity, R.string.wifi_changing_network, Toast.LENGTH_SHORT).show();
                }
            });
            new WifiConfigManager(wifiManager).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, getResult());

            activity.onBackPressed();
        }
    }

    // Display the name of the network and the network type to the user.
    @Override
    public CharSequence getDisplayContents() {
        WifiParsedResult wifiResult = getResult();
        return wifiResult.getSsid() + " (" + wifiResult.getNetworkEncryption() + ')';
    }

    @Override
    public String getDisplayTitle() {
        WifiParsedResult wifiResult = getResult();
        return wifiResult.getSsid() + " (" + wifiResult.getNetworkEncryption() + ')';
    }

    @Override
    public String getDisplaySubtitle() {
        return getResult().getPassword();
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    public int getDisplayIconRes() {
        return ThemesHelper.getResourceId(getActivity(), R.attr.ui_qr_ico_wifi);
    }
}