package net.doo.snap.lib.snap.edit;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;

import com.google.inject.Inject;

import net.doo.snap.lib.IntentExtras;
import net.doo.snap.lib.R;
import net.doo.snap.lib.snap.edit.events.DocumentRenamedEvent;
import net.doo.snap.lib.ui.HoloDialogFragment;
import net.doo.snap.lib.util.FileUtils;

import roboguice.event.EventManager;

/**
 * Used to change {@link net.doo.snap.lib.persistence.DocumentDraft#documentName} property.
 * Triggers {@link net.doo.snap.lib.snap.edit.events.DocumentRenamedEvent} to notify other entities on new name submission
 */
public class RenameDocumentFragment extends HoloDialogFragment {
    @Inject
    private EventManager eventManager;

    private EditText nameView;
    private AlertDialog dialog;

    public static RenameDocumentFragment newInstance(Bundle args) {
        RenameDocumentFragment fragment = new RenameDocumentFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    protected View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Bundle args = getArguments();
        String currentName = args.getString(IntentExtras.CURRENT_NAME);
        int titleRes = args.getInt(IntentExtras.TITLE, R.string.rename_document_fragment_title);
        int hintRes = args.getInt(IntentExtras.HINT, R.string.rename_document_hint);

        setTitle(titleRes);

        setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                eventManager.fire(new DocumentRenamedEvent(nameView.getText().toString()));
                dismiss();
            }
        });
        setNegativeButton(android.R.string.cancel, null);

        View content = LayoutInflater.from(getActivity()).inflate(R.layout.rename_fragment, null);
        nameView = (EditText) content.findViewById(R.id.name);
        nameView.setText(currentName);
        nameView.setHint(hintRes);
        return content;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE
                | WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);

        final Button positiveButton = getButton(DialogInterface.BUTTON_POSITIVE);
        nameView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                positiveButton.setEnabled(FileUtils.isFileNameSafe(s));
            }

            @Override
            public void afterTextChanged(Editable s) {
            }
        });
    }

}
