package net.doo.snap.lib.snap.event;

import net.doo.snap.lib.persistence.DocumentDraft;

/**
 * Sent when the {@link net.doo.snap.lib.persistence.DocumentDraft} state has been changed
 */
public class PagesChangedEvent {

    private final DocumentDraft draft;
    private final boolean cameraShown;

    public PagesChangedEvent(DocumentDraft draft, boolean cameraShown) {
        this.draft = draft;
        this.cameraShown = cameraShown;
    }

    /**
     * @return {@link net.doo.snap.lib.persistence.DocumentDraft} with the latest state
     */
    public DocumentDraft getDraft() {
        return draft;
    }

    public boolean isCameraShown() {
        return cameraShown;
    }
}
