/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import net.doo.snap.lib.billing.BillingManager;
import net.doo.snap.lib.ui.themes.Theme;
import net.doo.snap.lib.ui.themes.ThemesProvider;
import roboguice.RoboGuice;
import roboguice.activity.RoboFragmentActivity;
import roboguice.inject.RoboInjector;

public class CustomThemeActivity
extends RoboFragmentActivity {
    private ThemesProvider themesProvider;
    private BillingManager billingManager;

    protected void onCreate(Bundle savedInstanceState) {
        this.themesProvider = this.initThemesProvider();
        this.billingManager = this.initBillingManager();
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this);
        Theme theme = Theme.getThemeById(preferences.getInt("CURRENT_THEME", Theme.SCANBOT.getId()));
        if (this.billingManager.isItemAvailable("pro_pack") && theme != Theme.SCANBOT) {
            this.setTheme(this.themesProvider.getThemeResId(theme));
        } else {
            this.setTheme(this.themesProvider.getThemeResId(Theme.SCANBOT));
            preferences.edit().putInt("CURRENT_THEME", Theme.SCANBOT.getId()).apply();
        }
        super.onCreate(savedInstanceState);
    }

    private BillingManager initBillingManager() {
        RoboInjector injector = RoboGuice.getInjector((Context)this);
        return (BillingManager)injector.getProvider(BillingManager.class).get();
    }

    protected ThemesProvider initThemesProvider() {
        RoboInjector injector = RoboGuice.getInjector((Context)this);
        return (ThemesProvider)injector.getProvider(ThemesProvider.class).get();
    }
}

