/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import net.doo.snap.lib.ui.widget.text.TypefaceProvider;
import net.doo.snap.lib.util.ThemesHelper;

public class TermSpanDrawable
extends Drawable {
    private final Typeface typeface;
    private final Paint textPaint;
    private final String textToDraw;
    private float textX;
    private float textY;
    private final NinePatchDrawable bgDrawable;

    public TermSpanDrawable(Context context, String text) {
        if (text == null) {
            text = "";
        }
        Resources resources = context.getResources();
        this.typeface = new TypefaceProvider().getTypeface(context, resources.getString(2131165230));
        this.bgDrawable = (NinePatchDrawable)resources.getDrawable(ThemesHelper.getResourceId(context, 2130772070));
        this.textPaint = this.getTextPaint(resources);
        this.textToDraw = text;
        Rect textBounds = new Rect();
        this.textPaint.getTextBounds(this.textToDraw, 0, this.textToDraw.length(), textBounds);
        int height = resources.getDimensionPixelSize(2131427347);
        int padding = resources.getDimensionPixelSize(2131427348);
        this.bgDrawable.setBounds(0, 0, textBounds.width() + padding * 2, height);
    }

    protected Paint getTextPaint(Resources resources) {
        Paint paint = new Paint(1);
        paint.setColor(resources.getColor(17170443));
        paint.setTextSize(resources.getDimension(2131427346));
        paint.setTypeface(this.typeface);
        paint.setTextAlign(Paint.Align.CENTER);
        return paint;
    }

    public void draw(Canvas canvas) {
        this.bgDrawable.draw(canvas);
        canvas.drawText(this.textToDraw, this.textX, this.textY, this.textPaint);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.textX = (float)bounds.width() / 2.0f;
        this.textY = (float)bounds.height() * 0.7f;
    }

    public int getIntrinsicWidth() {
        return this.bgDrawable.getBounds().width();
    }

    public int getIntrinsicHeight() {
        return this.bgDrawable.getBounds().height() + 2;
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }
}

