package net.doo.snap.lib.snap.edit;

import net.doo.snap.lib.snap.PreviewFragmentPagerAdapter;
import net.doo.snap.lib.ui.widget.ViewPager;

/**
 * Attaches to {@link net.doo.snap.lib.ui.widget.ViewPager} and corresponding {@link net.doo.snap.lib.snap.PreviewFragmentPagerAdapter}
 * to observe events related to edit actions
 *
 * @see net.doo.snap.lib.snap.edit.drag.PagesRearranger
 * @see net.doo.snap.lib.snap.edit.DeletePageEditor
 * @see net.doo.snap.lib.snap.edit.RotatePageEditor
 */
public interface PagesEditor {

    /**
     * Attaches {@link net.doo.snap.lib.ui.widget.ViewPager}, so editor can perform actions
     * with content.
     *
     * @param viewPager
     * @param adapter
     */
    public void attachViewPager(ViewPager viewPager, PreviewFragmentPagerAdapter adapter);

}
