/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.billing;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.doo.snap.lib.billing.BillingConstants;
import net.doo.snap.lib.billing.BillingContent;
import net.doo.snap.lib.billing.BillingManager;
import net.doo.snap.lib.util.billing.IabException;
import net.doo.snap.lib.util.billing.IabHelper;
import net.doo.snap.lib.util.billing.IabResult;
import net.doo.snap.lib.util.billing.Inventory;
import net.doo.snap.lib.util.billing.Purchase;
import net.doo.snap.lib.util.log.DebugLog;

public class BillingManagerImpl
implements BillingManager {
    private static final int PURCHASE_REQUEST_CODE = 999000;
    private static final int ITEM_PURCHASED = 0;
    private static final Handler MAIN_LOOPER_HANDLER = new Handler(Looper.getMainLooper());
    private IabHelper iabHelper;
    private ExecutorService singleThreadExecutor;
    @Inject
    private SharedPreferences preferences;

    @Inject
    public BillingManagerImpl() {
    }

    @Override
    public void initialize(Context context, final IabHelper.OnIabSetupFinishedListener listener) {
        this.singleThreadExecutor = Executors.newSingleThreadExecutor();
        this.iabHelper = new IabHelper(context);
        this.iabHelper.startSetup(new IabHelper.OnIabSetupFinishedListener(){

            @Override
            public void onIabSetupFinished(final IabResult result) {
                if (!result.isSuccess()) {
                    DebugLog.e("Problem setting up in-app billing: " + result);
                    BillingManagerImpl.this.notifySetupFinished(listener, result);
                    return;
                }
                if (BillingManagerImpl.this.iabHelper == null) {
                    return;
                }
                DebugLog.d("Setup successful.");
                BillingManagerImpl.this.refreshItemsAsync(new RefreshItemsListener(){

                    @Override
                    public void onItemsRefreshFinished() {
                        BillingManagerImpl.this.notifySetupFinished(listener, result);
                    }
                });
            }
        });
    }

    @Override
    public boolean isInitialized() {
        return this.iabHelper != null && this.iabHelper.isSetupDone();
    }

    @Override
    public boolean isItemAvailable(String itemId) {
        return true;
    }

    @Override
    public boolean isBillingContentAvailable(BillingContent billingContent) {
        switch (billingContent) {
            case PRO_PACK_CONTENT: {
                return this.isItemAvailable("pro_pack") || this.isItemAvailable("pro_pack_subscription");
            }
        }
        return false;
    }

    @Override
    public String getItemPrice(String itemId) {
        return this.preferences.getString("PRICE_" + itemId, "");
    }

    @Override
    public void refreshItems() {
        this.ensureInitialized();
        try {
            Inventory inventory = this.iabHelper.queryInventory(true, Arrays.asList(BillingConstants.ALL_SKUS));
            if (inventory == null) {
                return;
            }
            for (String sku : BillingConstants.ALL_SKUS) {
                boolean itemPurchased = inventory.hasPurchase(sku) && inventory.getPurchase(sku).getPurchaseState() == 0;
                SharedPreferences.Editor editor = this.preferences.edit();
                editor.putBoolean(sku, itemPurchased);
                if (inventory.hasDetails(sku)) {
                    editor.putString("PRICE_" + sku, inventory.getSkuDetails(sku).getPrice());
                }
                editor.apply();
            }
        }
        catch (IabException e) {
            DebugLog.logException(e);
        }
    }

    @Override
    public void refreshItemsAsync(final RefreshItemsListener listener) {
        if (this.singleThreadExecutor == null) {
            throw new IllegalStateException("Single thread executor was not initialized!");
        }
        if (this.singleThreadExecutor.isShutdown()) {
            return;
        }
        this.singleThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                BillingManagerImpl.this.refreshItems();
                BillingManagerImpl.this.notifyItemsRefreshFinished(listener);
            }
        });
    }

    @Override
    public void startBillingWorkflowForItem(Activity activity, final String itemId, final IabHelper.OnIabPurchaseFinishedListener listener) {
        this.ensureInitialized();
        IabHelper.OnIabPurchaseFinishedListener purchaseFinishedListener = new IabHelper.OnIabPurchaseFinishedListener(){

            @Override
            public void onIabPurchaseFinished(IabResult result, Purchase purchase) {
                BillingManagerImpl.this.refreshItems();
                if (result.getResponse() == 7 || result.getResponse() == 0) {
                    BillingManagerImpl.this.preferences.edit().putBoolean(itemId, true).apply();
                }
                BillingManagerImpl.this.notifyItemPurchaseFinished(result, purchase, listener);
            }
        };
        if (itemId == "pro_pack_subscription") {
            this.iabHelper.launchSubscriptionPurchaseFlow(activity, itemId, 999000, purchaseFinishedListener);
        } else {
            this.iabHelper.launchPurchaseFlow(activity, itemId, 999000, purchaseFinishedListener);
        }
    }

    @Override
    public boolean handleResult(int requestCode, int resultCode, Intent data) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.iabHelper.handleActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void dispose() {
        this.singleThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (BillingManagerImpl.this.iabHelper != null) {
                    BillingManagerImpl.this.iabHelper.dispose();
                    BillingManagerImpl.this.iabHelper = null;
                }
            }
        });
        this.singleThreadExecutor.shutdown();
    }

    private void notifySetupFinished(final IabHelper.OnIabSetupFinishedListener listener, final IabResult result) {
        if (listener != null) {
            MAIN_LOOPER_HANDLER.post(new Runnable(){

                @Override
                public void run() {
                    listener.onIabSetupFinished(result);
                }
            });
        }
    }

    private void notifyItemsRefreshFinished(final RefreshItemsListener listener) {
        if (listener != null) {
            MAIN_LOOPER_HANDLER.post(new Runnable(){

                @Override
                public void run() {
                    listener.onItemsRefreshFinished();
                }
            });
        }
    }

    private void notifyItemPurchaseFinished(final IabResult result, final Purchase purchase, final IabHelper.OnIabPurchaseFinishedListener listener) {
        if (listener != null) {
            MAIN_LOOPER_HANDLER.post(new Runnable(){

                @Override
                public void run() {
                    listener.onIabPurchaseFinished(result, purchase);
                }
            });
        }
    }

    private void ensureInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("IabHelper was not initialized!");
        }
    }

    public static interface RefreshItemsListener {
        public void onItemsRefreshFinished();
    }
}

