/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.ui;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ImageSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import net.doo.snap.lib.analytics.ActivityAnalytics;
import net.doo.snap.lib.smartname.SmartNameGenerator;
import net.doo.snap.lib.smartname.TermType;
import net.doo.snap.lib.smartname.TermTypeCategory;
import net.doo.snap.lib.ui.CustomThemeActivity;
import net.doo.snap.lib.ui.widget.TermSpanDrawable;
import net.doo.snap.lib.ui.widget.text.CustomTypefaceTextView;
import net.doo.snap.lib.util.FileUtils;
import net.doo.snap.lib.util.smartname.SmartNameUtil;
import net.doo.snap.lib.util.ui.ViewUtils;
import org.apache.commons.lang.StringUtils;

public class SmartNameActivity
extends CustomThemeActivity {
    @Inject
    private SmartNameGenerator smartNameBuilder;
    @Inject
    private SharedPreferences preferences;
    @Inject
    private ActivityAnalytics activityAnalytics;
    private EditText nameInput;
    private ViewGroup termsContainer;
    private View clearButton;
    private List<TermType> termsList = new ArrayList<TermType>();
    private TextView exampleTextView;
    private View saveBtn;
    private TextWatcher nameInputTextWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            int affectedTermsCount;
            if (count != 0 && count != after && (affectedTermsCount = StringUtils.countMatches((String)s.toString().substring(start, start + count), (String)"\t")) > 0) {
                int beforeTermsCount = StringUtils.countMatches((String)s.toString().substring(0, start), (String)"\t");
                SmartNameActivity.this.termsList.subList(beforeTermsCount, beforeTermsCount + affectedTermsCount).clear();
            }
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void afterTextChanged(Editable s) {
            SmartNameActivity.this.clearButton.setVisibility(TextUtils.isEmpty((CharSequence)s) ? 8 : 0);
            SmartNameActivity.this.updateExampleText();
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903063);
        this.getActionBar().hide();
        this.initUi();
        this.initTermsCategories();
        if (savedInstanceState == null) {
            this.restoreStateFromPreferences();
        } else {
            this.restoreStateFromBundle(savedInstanceState);
        }
    }

    private void initUi() {
        this.termsContainer = (ViewGroup)this.findViewById(2131296338);
        this.exampleTextView = (TextView)this.findViewById(2131296333);
        this.nameInput = (EditText)this.findViewById(2131296326);
        this.nameInput.addTextChangedListener(this.nameInputTextWatcher);
        this.nameInput.setCustomSelectionActionModeCallback(ViewUtils.DISABLED_ACTIONMODE_CALLBACK);
        this.nameInput.setLongClickable(false);
        this.nameInput.setTextIsSelectable(false);
        this.clearButton = this.findViewById(2131296325);
        this.clearButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SmartNameActivity.this.nameInput.setText((CharSequence)"");
            }
        });
        this.findViewById(2131296328).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SmartNameActivity.this.resetTemplate();
            }
        });
        this.saveBtn = this.findViewById(2131296329);
        this.saveBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CharSequence exampleText = SmartNameActivity.this.exampleTextView.getText();
                if (TextUtils.isEmpty((CharSequence)exampleText)) {
                    return;
                }
                if (FileUtils.isFileNameSafe(exampleText)) {
                    SmartNameActivity.this.saveSmartNameInfo();
                    SmartNameActivity.this.finish();
                } else {
                    Toast.makeText((Context)SmartNameActivity.this, (int)2131165300, (int)1).show();
                }
            }
        });
    }

    protected void onSaveInstanceState(Bundle outState) {
        ArrayList<String> typesList = new ArrayList<String>();
        for (TermType termType : this.termsList) {
            typesList.add(String.valueOf(termType.getId()));
        }
        outState.putString("SMART_NAME_TEMPLATE", this.nameInput.getText().toString());
        outState.putString("SMART_NAME_TERMS_TYPES", StringUtils.join(typesList, (String)"|"));
        outState.putString("SMART_NAME_EXAMPLE", this.exampleTextView.getText().toString());
        super.onSaveInstanceState(outState);
    }

    private void restoreStateFromPreferences() {
        String template = this.preferences.getString("SMART_NAME_TEMPLATE", null);
        String termsTypes = this.preferences.getString("SMART_NAME_TERMS_TYPES", null);
        this.restoreState(template, termsTypes);
    }

    private void restoreStateFromBundle(Bundle savedInstanceState) {
        String template = savedInstanceState.getString("SMART_NAME_TEMPLATE", null);
        String termsTypes = savedInstanceState.getString("SMART_NAME_TERMS_TYPES", null);
        this.restoreState(template, termsTypes);
    }

    private void restoreState(String template, String termsTypes) {
        if (StringUtils.isEmpty((String)template)) {
            this.resetTemplate();
            return;
        }
        if (!StringUtils.isEmpty((String)termsTypes)) {
            this.termsList.addAll(SmartNameUtil.convertTermsFromPreferencesFormat(termsTypes));
            this.setTemplateWithSpans(template);
        } else {
            this.nameInput.setText((CharSequence)template);
        }
    }

    private void resetTemplate() {
        this.nameInput.setText((CharSequence)"");
        this.termsList.addAll(SmartNameGenerator.DEFAULT_TERMS);
        this.setTemplateWithSpans("Scan \t-\t-\t \t.\t.\t");
    }

    private void setTemplateWithSpans(String template) {
        this.nameInput.setText((CharSequence)template);
        int j = 0;
        for (int i = 0; i < template.length(); ++i) {
            if ("\t".charAt(0) != template.charAt(i)) continue;
            this.addSpan(this.termsList.get(j++), i, i + 1);
        }
    }

    private void saveSmartNameInfo() {
        ArrayList<String> typesList = new ArrayList<String>();
        for (TermType termType : this.termsList) {
            typesList.add(String.valueOf(termType.getId()));
        }
        this.preferences.edit().putString("SMART_NAME_TEMPLATE", this.nameInput.getText().toString()).putString("SMART_NAME_TERMS_TYPES", StringUtils.join(typesList, (String)"|")).putString("SMART_NAME_EXAMPLE", this.exampleTextView.getText().toString()).apply();
    }

    private void addSpan(TermType termType, int start, int end) {
        TermSpanDrawable spanDrawable = new TermSpanDrawable((Context)this, this.getString(termType.getDisplayNameResId()));
        spanDrawable.setBounds(0, 0, spanDrawable.getIntrinsicWidth(), spanDrawable.getIntrinsicHeight());
        ImageSpan span = new ImageSpan((Drawable)spanDrawable);
        this.nameInput.getText().setSpan((Object)span, start, end, 33);
        this.nameInput.setSelection(end);
        this.updateExampleText();
    }

    private void addTerm(TermType termType) {
        int selectionStart = this.nameInput.getSelectionStart();
        int affectedTermsCount = StringUtils.countMatches((String)this.nameInput.getText().toString().substring(0, selectionStart), (String)"\t");
        this.termsList.add(affectedTermsCount, termType);
        this.nameInput.getText().insert(selectionStart, (CharSequence)"\t");
        this.addSpan(termType, selectionStart, selectionStart + 1);
    }

    private void initTermsCategories() {
        for (TermTypeCategory category : TermTypeCategory.values()) {
            LinearLayout categoryView = (LinearLayout)View.inflate((Context)this, (int)2130903065, null);
            ((CustomTypefaceTextView)categoryView.findViewById(2131296336)).setText(category.getDisplayNameResId());
            this.initTerms(category, categoryView);
            this.termsContainer.addView((View)categoryView);
        }
    }

    private void initTerms(TermTypeCategory category, LinearLayout categoryView) {
        for (final TermType termType : category.getTermTypes()) {
            CustomTypefaceTextView termView = (CustomTypefaceTextView)View.inflate((Context)this, (int)2130903064, null);
            termView.setText(termType.getDisplayNameResId());
            termView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SmartNameActivity.this.addTerm(termType);
                }
            });
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.setMargins(this.getResources().getDimensionPixelSize(2131427345), 0, this.getResources().getDimensionPixelSize(2131427345), 0);
            categoryView.addView((View)termView, (ViewGroup.LayoutParams)params);
        }
    }

    private void updateExampleText() {
        String nameInputText = this.nameInput.getText().toString();
        String nameExample = this.smartNameBuilder.generateDocumentName(nameInputText, this.termsList);
        this.exampleTextView.setText((CharSequence)nameExample);
    }
}

