package net.doo.snap.lib.sensor;

/**
 * Gets notified about move that passed threshold
 * returned by {@code getSignificantMoveThreshold()} method
 */
public interface SignificantMoveListener {
    /**
     * Used to determine device movement that can make image blurry
     */
    final float THRESHOLD_LOW = 0.6f;
    /**
     * Used to determine shake events
     */
    final float THRESHOLD_HIGH = 5f;

    /**
     *
     * @return minimum threshold that is needed to get {@call onSignificantMove)} call
     */
    float getSignificantMoveThreshold();

    /**
     * Implement this to get notified about significant move
     */
    void onSignificantMove();
}
