package net.doo.snap.lib.snap;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.google.inject.Inject;

import net.doo.snap.lib.R;
import net.doo.snap.lib.analytics.AnalyticsConst;
import net.doo.snap.lib.analytics.EasyTrackerWrapper;
import net.doo.snap.lib.persistence.DocumentDraft;
import net.doo.snap.lib.snap.event.ProcessDocumentsEvent;
import net.doo.snap.lib.ui.HoloDialogFragment;

import roboguice.event.EventManager;

/**
 * UI to select possibility (single/multiple) to save the document with the {@link net.doo.snap.lib.persistence.DocumentProcessor}
 */
public class SaveModeFragment extends HoloDialogFragment {

    private static final String PAGES_HOLDER = "DOCUMENT_DRAFT";

    @Inject
    private EventManager eventManager;

    /**
     * Creates new instance of {@link net.doo.snap.lib.snap.SaveModeFragment}
     *
     * @param holder {@link net.doo.snap.lib.persistence.DocumentDraft} with the latest state
     */
    public static SaveModeFragment newInstance(DocumentDraft holder) {
        SaveModeFragment fragment = new SaveModeFragment();
        Bundle args = new Bundle();
        args.putParcelable(PAGES_HOLDER, holder);
        fragment.setArguments(args);

        return fragment;
    }

    @Override
    public View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        setTitle(R.string.save_mode_fragment_title);
        final DocumentDraft documentDraft = getArguments().getParcelable(PAGES_HOLDER);
        View view = inflater.inflate(R.layout.save_mode_fragment, null, false);
        view.findViewById(R.id.single).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                eventManager.fire(new ProcessDocumentsEvent(documentDraft, true));
                dismiss();

                EasyTrackerWrapper.sendEvent(AnalyticsConst.CATEGORY_UI, AnalyticsConst.ACTION_BUTTON_PRESS, "save_single_document", 0L);
            }
        });
        view.findViewById(R.id.multiple).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                eventManager.fire(new ProcessDocumentsEvent(documentDraft, false));
                dismiss();

                EasyTrackerWrapper.sendEvent(AnalyticsConst.CATEGORY_UI, AnalyticsConst.ACTION_BUTTON_PRESS, "save_multiple_documents", 0L);
            }
        });
        return view;
    }
}
