package net.doo.snap.lib.ui.widget.text;

import android.content.Context;
import android.graphics.Typeface;

import java.util.HashMap;

/**
 * Provides {@link android.graphics.Typeface} by filename from assets folder.
 * Statically caches data.
 */
public class TypefaceProvider {

    /**
     * Cache for loaded typefaces, which let you avoid loading a new one every time
     * {@link CustomTypefaceTextView} is created
     */
    private static final HashMap<String, Typeface> TYPEFACE_MAP = new HashMap<String, Typeface>();

    /**
     * @return {@link android.graphics.Typeface} by filename from assets folder.
     * @throws java.lang.NullPointerException if either context or name is {@code null}
     */
    public Typeface getTypeface(Context context, String name) throws NullPointerException {
        if (context == null || name == null) {
            throw new NullPointerException("Parameters can't be null");
        }

        if (TYPEFACE_MAP.containsKey(name)) {
            return TYPEFACE_MAP.get(name);
        }

        Typeface typeface = Typeface.createFromAsset(context.getAssets(), name);
        TYPEFACE_MAP.put(name, typeface);

        return typeface;
    }

}
