/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.camera;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.ImageFormat;
import android.graphics.PointF;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Looper;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.CameraUtils;
import com.commonsware.cwac.camera.PictureTransaction;
import com.commonsware.cwac.camera.SimpleCameraHost;
import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.doo.snap.lib.detector.CameraDetectorListener;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.lib.snap.camera.CameraActivity;
import net.doo.snap.lib.snap.camera.CameraPreviewFragment;
import net.doo.snap.lib.snap.camera.DetectionTask;
import net.doo.snap.lib.snap.camera.barcode.BarcodeDetector;
import net.doo.snap.lib.util.log.DebugLog;
import net.doo.snap.lib.util.snap.Utils;

public class SnapCameraHost
extends SimpleCameraHost
implements Camera.PreviewCallback {
    private static final int MAX_FOCUS_FAIL_COUNT = 3;
    @Inject
    private BarcodeDetector barcodeDetector;
    @Inject
    private SharedPreferences preferences;
    private CameraPreviewFragment cameraPreviewFragment;
    private final Executor executor;
    private final ContourDetector detector;
    private boolean useContourDetection = true;
    private CameraDetectorListener cameraDetectorListener;
    private int orientation;
    private int width;
    private int height;
    private int previewWidth;
    private int previewHeight;
    private int failedFocusCount = 0;
    private Handler mainLooperHandler = new Handler(Looper.getMainLooper());

    @Inject
    public SnapCameraHost(Context context) {
        super(context);
        this.detector = new ContourDetector();
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    public void setCameraPreviewFragment(final CameraPreviewFragment cameraPreviewFragment) {
        this.cameraPreviewFragment = cameraPreviewFragment;
        this.cameraDetectorListener = new CameraDetectorListener(){

            @Override
            public void onDetectionOK(List<PointF> polygon) {
                if (cameraPreviewFragment != null && cameraPreviewFragment.getDetectorListener() != null) {
                    cameraPreviewFragment.getDetectorListener().onDetectionOK(polygon);
                    cameraPreviewFragment.onPolygonDetected();
                }
            }

            @Override
            public void onBarcodeDetectionOK(String content) {
                if (cameraPreviewFragment != null && cameraPreviewFragment.getActivity() != null) {
                    cameraPreviewFragment.onBarcodeDetected();
                }
            }

            @Override
            public void onDetectionWithError(DetectionResult result, List<PointF> polygon) {
                if (cameraPreviewFragment != null && cameraPreviewFragment.getDetectorListener() != null) {
                    cameraPreviewFragment.getDetectorListener().onDetectionWithError(result, polygon);
                    cameraPreviewFragment.onPolygonDetected();
                }
            }

            @Override
            public void onDetectionFailed(DetectionResult result) {
                if (cameraPreviewFragment != null && cameraPreviewFragment.getDetectorListener() != null) {
                    cameraPreviewFragment.getDetectorListener().onDetectionFailed(result);
                }
            }
        };
    }

    @Override
    public Camera.Parameters adjustPreviewParameters(Camera.Parameters parameters) {
        Utils.enableContinuousFocus(parameters);
        final boolean flashSupported = Utils.isFlashSupported(parameters);
        this.mainLooperHandler.post(new Runnable(){

            @Override
            public void run() {
                SnapCameraHost.this.cameraPreviewFragment.setFlashButtonVisible(flashSupported);
            }
        });
        if (flashSupported) {
            parameters.setFlashMode(this.cameraPreviewFragment.isFlashEnabled() ? "torch" : "off");
        }
        return parameters;
    }

    @Override
    public void onAutoFocus(boolean success, Camera camera) {
        if (this.cameraPreviewFragment.isRefocusing()) {
            this.cameraPreviewFragment.finishRefocusing();
            return;
        }
        boolean isAutoSnapEnabled = this.cameraPreviewFragment.isAutosnapEnabled();
        if (this.useContourDetection || !isAutoSnapEnabled) {
            if (!success && isAutoSnapEnabled && this.failedFocusCount < 3) {
                ++this.failedFocusCount;
                camera.cancelAutoFocus();
            } else {
                this.failedFocusCount = 0;
                this.takePicture();
            }
        }
    }

    private void takePicture() {
        this.useContourDetection = false;
        this.cameraPreviewFragment.onStartPictureProcessing();
        this.cameraPreviewFragment.takePicture(new PictureTransaction(this).needBitmap(false).needByteArray(true).useSingleShotMode(true));
    }

    @Override
    public void saveImage(PictureTransaction xact, byte[] image, int imageOrientation) {
        this.cameraPreviewFragment.onPictureTaken(image, imageOrientation);
        this.cameraPreviewFragment.onFinishPictureProcessing();
        try {
            this.cameraPreviewFragment.cancelAutoFocus();
        }
        catch (RuntimeException e) {
            DebugLog.logException(e);
        }
    }

    public void onPreviewFrame(byte[] image, Camera camera) {
        if (this.useContourDetection) {
            this.barcodeDetector.enableBarcodeScan(this.cameraPreviewFragment.getActivity() != null && !(this.cameraPreviewFragment.getActivity() instanceof CameraActivity) && this.preferences.getBoolean("SCAN_BARCODES", true));
            this.executor.execute(new DetectionTask(this.barcodeDetector, this.detector, image, this.previewWidth, this.previewHeight, this.cameraDetectorListener));
        }
    }

    public void setUseContourDetection(boolean useContourDetection) {
        this.useContourDetection = useContourDetection;
    }

    public boolean useContourDetection() {
        return this.useContourDetection;
    }

    @Override
    public CameraHost.RecordingHint getRecordingHint() {
        return CameraHost.RecordingHint.STILL_ONLY;
    }

    @Override
    public final Camera.Size getPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        this.orientation = displayOrientation;
        this.width = width;
        this.height = height;
        Camera.Size previewSize = this.findPreviewSize(displayOrientation, width, height, parameters);
        this.previewWidth = previewSize.width;
        this.previewHeight = previewSize.height;
        return previewSize;
    }

    protected Camera.Size findPreviewSize(int displayOrientation, int width, int height, Camera.Parameters parameters) {
        return CameraUtils.getBestAspectPreviewSize(displayOrientation, width, height, parameters);
    }

    public byte[] getNewPreviewBuffer() {
        return new byte[this.previewWidth * this.previewHeight * ImageFormat.getBitsPerPixel((int)17) / 8];
    }

    @Override
    public Camera.Size getPictureSize(PictureTransaction xact, Camera.Parameters parameters) {
        return Utils.getLargestPictureSize(parameters);
    }

    @Override
    public boolean useFullBleedPreview() {
        return true;
    }
}

