package net.doo.snap.lib.util;

import android.content.Context;
import android.content.res.TypedArray;

/**
 * Provides utils methods for fetching resource ids for current theme
 */
public class ThemesHelper {

    /**
     * @param context
     * @param attributeId resources attribute id
     * @return resource id
     */
    public static int getResourceId(Context context, int attributeId) {
        TypedArray values = context.obtainStyledAttributes(new int[]{attributeId});
        try {
            int base = values.getResourceId(0, 0);
            return base;
        } finally {
            values.recycle();
        }
    }
}
