package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;
import android.telephony.PhoneNumberUtils;

import com.google.zxing.client.result.TelParsedResult;

import net.doo.snap.lib.R;
import net.doo.snap.lib.util.ThemesHelper;

/**
 * Offers relevant actions for telephone numbers.
 */
public final class TelResultHandler extends ResultHandler {
    private static final int[] buttons = {
            R.string.button_dial,
            R.string.button_add_contact
    };
    private static final int CALL = 0;
    private static final int ADD_TO_CONTACTS = 1;

    public TelResultHandler(Activity activity, TelParsedResult result) {
        super(activity, result);
    }

    @Override
    public TelParsedResult getResult() {
        return (TelParsedResult) super.getResult();
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        TelParsedResult telResult = getResult();
        switch (index) {
            case CALL:
                dialPhoneFromUri(telResult.getTelURI());
                // When dialer comes up, it allows underlying display activity to continue or something,
                // but app can't get camera in this state. Avoid issues by just quitting, only in the
                // case of a phone number
                getActivity().finish();
                break;
            case ADD_TO_CONTACTS:
                String[] numbers = new String[] {
                        telResult.getNumber()
                };
                addPhoneOnlyContact(numbers, null);
                break;
        }
    }

    // Overriden so we can take advantage of Android's phone number hyphenation routines.
    @Override
    public CharSequence getDisplayContents() {
        String contents = getResult().getDisplayResult();
        contents = contents.replace("\r", "");
        return PhoneNumberUtils.formatNumber(contents);
    }

    @Override
    public String getDisplayTitle() {
        return getResult().getNumber();
    }

    @Override
    public String getDisplaySubtitle() {
        return null;
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    public int getDisplayIconRes() {
        return ThemesHelper.getResourceId(getActivity(), R.attr.ui_qr_ico_phone);
    }
}
