package net.doo.snap.lib.ui.tutorial;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import net.doo.snap.lib.PreferencesConstants;
import net.doo.snap.lib.R;

/**
 * Shown when first page was snapped
 */
public class AddNewPageTutorialFragment extends OneTimeFragment {

    private View okButton;

    /**
     * @return new instance of {@link net.doo.snap.lib.ui.tutorial.AddNewPageTutorialFragment}
     */
    public static AddNewPageTutorialFragment newInstance() {
        return new AddNewPageTutorialFragment();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        View rootView = inflater.inflate(R.layout.add_new_page_tutorial, container, false);

        okButton = rootView.findViewById(R.id.ok);

        return rootView;
    }

    @Override
    protected String getDialogId() {
        return PreferencesConstants.ADD_NEW_PAGE_TUTORIAL;
    }

    @Override
    protected View getCancelView() {
        return okButton;
    }
}
